function enableSubmitButton(baseHtmlId) {
    let submitButton = $('#' + baseHtmlId);
    submitButton.removeClass('disabled disabled-menu-item');
    const icon = $('#' + baseHtmlId + '_icon');
    const iconBase = icon.data("icon-template");
    const iconWorking = icon.data("icon-template-working");
    icon.removeClass(iconWorking);
    icon.addClass(iconBase);
    const label = $('#' + baseHtmlId + '_label');
    const labelBase = label.data("label-template");
    label.text(labelBase);
}

$(document).ready(function () {
    $('script[id$="_submitbutton_js"]').each(function () {
        const baseHtmlId = $(this).data('base_html_id');
        const submitButton = $('#' + baseHtmlId);
        submitButton.click(function () {
            let emptyRequiredFields = false;

            // Check for empty mandatory input fields
            submitButton.parents('form').find('input').each(function(){
                if($(this).prop('required') && !$(this).val()){
                    emptyRequiredFields = true;
                }
            });

            // Check for empty mandatory textarea fields
            submitButton.parents('form').find('textarea').each(function(){
                if($(this).prop('required') && !$(this).val()){
                    emptyRequiredFields = true;
                }
            });

            // Check for mandatory select fields with an empty selection
            submitButton.parents('form').find('select').each(function(){
                if($(this).prop('required') && !$(this).find(":selected").val()){
                    emptyRequiredFields = true;
                }
            });

            if (emptyRequiredFields) {
                // do nothing when there are empty required fields in the submit button's form
                return;
            }

            // disable button after it was clicked
            $(this).addClass('disabled disabled-menu-item');

            // change the displayed icon & label
            const icon = $('#' + baseHtmlId + '_icon');
            const iconBase = icon.data("icon-template");
            const iconWorking = icon.data("icon-template-working");
            icon.removeClass(iconBase);
            icon.addClass(iconWorking);
            const label = $('#' + baseHtmlId + '_label');
            const labelWorking = label.data("label-template-working");
            label.text(labelWorking);
        });

        // Enable the submit button again whenever a parent modal is shown
        submitButton.parents('.modal').on('shown.bs.modal', function () {
            submitButton.removeClass('disabled disabled-menu-item');
            const icon = $('#' + baseHtmlId + '_icon');
            const iconBase = icon.data("icon-template");
            const iconWorking = icon.data("icon-template-working");
            icon.removeClass(iconWorking);
            icon.addClass(iconBase);
            const label = $('#' + baseHtmlId + '_label');
            const labelBase = label.data("label-template");
            label.text(labelBase);
        });
    });
})