const userform_js = $('#userform_js');
const bankIds = userform_js.attr('data-banks').split(',');
const userId = userform_js.attr('data-userId');
const existingUser = !isNaN(userId);

function bankChecked() {
    const localUser = $('input:checkbox[id="localUser"]').prop('checked');

    bankIds.forEach(function (bankId) {
        if ($('#banks_' + bankId).prop('checked')) {
            if (!localUser) {
                $('#subscriberIDs_' + bankId).show();
            }
            $('#bank' + bankId + '-accordion').show();
        } else {
            $('#subscriberIDs_' + bankId).hide();
            $('#bank' + bankId + '-accordion').hide();
        }
    });
}

function localUserChanged() {
    const localUser = $('input:checkbox[id="localUser"]').prop('checked');
    bankIds.forEach(function (bankId) {
        if (!localUser && $('#banks_' + bankId).prop('checked')) {
            $('#subscriberIDs_' + bankId).show();
        } else {
            $('#subscriberIDs_' + bankId).hide();
        }
    });
}

function adminUserChanged() {
    const isAdminUser = $('input:checkbox[id="isAdmin"]').prop('checked');
    let field = $('#banking_allowEditBankSettings_field');

    if (!isAdminUser) {
        field.show();
    } else {
        field.hide();
    }

}

function accountPermissionChanged(e) {
    const r = /accounts_(\d+)_([a-z]+)/.exec($(e.target).attr('id'));
    $('#accountLimits_' + r[1]).prop('disabled', (r[2] !== 'true'));
}

$(document).ready(function () {
    $('input[id^=banks_][type=checkbox]').change(bankChecked);
    bankChecked();
    $('#flashRemovingBankDeletesKeys').hide();

    if(!existingUser){
        $('#password').attr("autocomplete","new-password");
        $('#confirmPassword').attr("autocomplete","new-password");
    }

    $('input[id=localUser][type=checkbox]').change(localUserChanged);
    localUserChanged();

    $('input[id=isAdmin][type=checkbox]').change(adminUserChanged).change();

    // add tooltip on account name, account number and bank code will be shown
    $('label[for^="accounts_"]').each(function() {
        let radio = $( this ).attr("for");
        let radioId =  'input[id=' + radio + "_true" + ']';
        let title = $(radioId).attr("labeltitle");
        $( this ).attr("title", title);
    });

    $('input[type=radio][id^=accounts_]').change(accountPermissionChanged);
    const accountLimitFields = $('input[type=text][id^=accountLimits_]');
    if (accountLimitFields.length) {
        accountLimitFields.keydown(checkInputDecimalNumeric);
        accountLimitFields.change(function (e) {
            amountFieldChanged($(e.target));
        });
    }

    // ignore clicking on readonly checkboxes
    $(document).on('click', function(e){
        // check for type, avoid selecting the element for performance
        if(e.target.type === 'checkbox') {
            let el = jQuery(e.target);
            if(el.attr('readonly')!=null && el.attr('readonly') === "true") {
                // prevent it from changing state
                e.preventDefault();
            }
        }
    });


    $('button[id^=select_all_bank_]').click(function () {
        let id = $(this).attr('id').substring("select_all_bank_".length);
        let radioId =  '#bank' + id + "-accordion-body input[type='radio'][id$=true]";
        $(radioId).each(function () {
            $(this).prop('checked', true);
        });
    });

    $('button[id^=select_none_bank_]').click(function () {
        let id = $(this).attr('id').substring("select_none_bank_".length);
        let radioId =  '#bank' + id + "-accordion-body input[type='radio'][id$=false]";
        $(radioId).each(function () {
            $(this).prop('checked', true);
        });
    });

    $('button[id^=select_default_bank_]').click(function () {
        let id = $(this).attr('id').substring("select_default_bank_".length);
        let radioId =  '#bank' + id + "-accordion-body input[type='radio'][id$=default]";
        $(radioId).each(function () {
            $(this).prop('checked', true);
        });
    });

    $('#select_all_banks').click(function () {
        $('input[id^="banks_"]').prop('checked', true);
        $('input[id^=banks_][type=checkbox]').change();
    });

    $('#select_no_banks').click(function () {
        $('input[id^="banks_"]').prop('checked', false);
        $('input[id^=banks_][type=checkbox]').change();
    });

})
