/**
 * Parameters for the current script
 * @type {
 *     {openNewTenantModalDirectly : boolean}
 * }
 */

const tenantsParams = JSON.parse(atob($('#tenants_js').attr('data-params')));

function checkboxCallback(itemSelected) {
    const deleteButton = $('#delete_button');
    const editButton = $('#actions_menu_edit_tenant');
    const usersButton = $('#user_administration_button');
    if (itemSelected === 1) {
        const selection = getSelectedIds('tenantsTable_select');
        deleteButton.removeClass('disabled disabled-menu-item');
        if (typeof deleteButton.data('link') !== 'undefined') {
            deleteButton.attr('href', replaceAll(deleteButton.data('link'), '999', selection));
        }
        editButton.removeClass('disabled disabled-menu-item');
        fillEditModal();

        usersButton.removeClass('disabled disabled-menu-item');
        if (typeof usersButton.data('link') !== 'undefined') {
            usersButton.attr('href', replaceAll(usersButton.data('link'), '999', selection));
        }
    } else {
        deleteButton.addClass('disabled disabled-menu-item');
        deleteButton.removeAttr('href');
        editButton.addClass('disabled disabled-menu-item');
        clearEditModal();

        usersButton.addClass('disabled disabled-menu-item');
        usersButton.removeAttr('href');
    }

    const selectedIds = getSelectedIds('tenantsTable_select');
    setHiddenFormTextParameter($('#export_customer_form'), selectedIds);
    setHiddenFormTextParameter($('#export_user_form'), selectedIds);
}

function fillEditModal(){
    const selectedId = getSelectedIds('tenantsTable_select');
    let name = $('#tenantsTable_row_'+selectedId).children().eq(1).text();
    let max = $('#tenantsTable_row_'+selectedId).children().eq(3).text();
    var e = parseInt(max);
    if(e==NaN){
        max="";
    }
    $('#edit_tenant_modal_name').val(name);
    $('#edit_tenant_modal_maxusercount').val(max);

    let linkDraw= $('#actions_menu_edit_tenant').data('link-temp');
    linkDraw=linkDraw.replace('777',selectedId);
    const link = $('#actions_menu_edit_tenant').attr('data-link', linkDraw);
}

function clearEditModal(){
    $('#edit_tenant_modal_name').val('');
    $('#edit_tenant_modal_maxusercount').val('');
    $('#actions_menu_edit_tenant').data('link','');
    $('#edit_invalid_name_warning').hide();
}


$(document).ready(function () {
    $('#export_customer').click(function () {
        $('#export_customer_form').submit();
    });
    $('#export_user').click(function () {
        $('#export_user_form').submit();
    });
    $('#tenants_filter_reset_button').click(function () {
        $('#filter_modal input[name!="csrfToken"]').val('');
    });

    //pass parameter
    let openDirectly = tenantsParams.openNewTenantModalDirectly;
     if(openDirectly) {
        $('#actions_menu_new_tenant').click();
    }
});
