/**
 * Parameters for the current script
 * @type {
 *     {ebics3Banks : [string]},
 *     {userIsAdmin : Boolean}
 * }
 */
const fetchScheduleJs = $('#fetch_schedule_js');
const fetchScheduleParams = JSON.parse(atob(fetchScheduleJs.attr('data-params')));

function checkEbicsVersionOfBank() {
    let bankSelect = document.getElementById("bankId");
    if (fetchScheduleParams.ebics3Banks.includes(bankSelect.value)) {
        $('#fetchordertype_btf_modify_button').removeClass('disabled disabled-menu-item');
    } else {
        $('#fetchordertype_btf_modify_button').addClass('disabled disabled-menu-item');
    }
}

function updateUserFields() {
    // hide user fields for all banks
    $('div[id^=user_]').hide();

    if (fetchScheduleParams.userIsAdmin === true) {
        // show user field for the (new) selected bank
        const bank = $('#bankId').find('option:selected').val();
        $('#user_' + bank + '_field').show();
    }
}

function selectAllDays(withWeekend) {
    $('#monday').prop('checked', true);
    $('#tuesday').prop('checked', true);
    $('#wednesday').prop('checked', true);
    $('#thursday').prop('checked', true);
    $('#friday').prop('checked', true);
    $('#saturday').prop('checked', withWeekend);
    $('#sunday').prop('checked', withWeekend);
}


function selectAllMonths() {
    $('#month1').prop('checked', true);
    $('#month2').prop('checked', true);
    $('#month3').prop('checked', true);
    $('#month4').prop('checked', true);
    $('#month5').prop('checked', true);
    $('#month6').prop('checked', true);
    $('#month7').prop('checked', true);
    $('#month8').prop('checked', true);
    $('#month9').prop('checked', true);
    $('#month10').prop('checked', true);
    $('#month11').prop('checked', true);
    $('#month12').prop('checked', true);
}

function selectQuarters() {
    $('#month1').prop('checked', true);
    $('#month2').prop('checked', false);
    $('#month3').prop('checked', false);
    $('#month4').prop('checked', true);
    $('#month5').prop('checked', false);
    $('#month6').prop('checked', false);
    $('#month7').prop('checked', true);
    $('#month8').prop('checked', false);
    $('#month9').prop('checked', false);
    $('#month10').prop('checked', true);
    $('#month11').prop('checked', false);
    $('#month12').prop('checked', false);
}


function repeatOptionChanged() {
    if ($('#onceADay').find('option:checked').val() === 'true') {
        $('#fetch-rhythm-daily').show();
        $('#fetch-rhythm-interval').hide();
    } else {
        $('#fetch-rhythm-daily').hide();
        $('#fetch-rhythm-interval').show();
    }
}

function executionTypeOptionChanged() {
    if ($('#weekOrMonth').find('option:checked').val() === '0') {
        $('#fetch-rhythm-week').show();
        $('#fetch-rhythm-month').hide();
    } else {
        $('#fetch-rhythm-week').hide();
        $('#fetch-rhythm-month').show();
    }
}

function schedulerTypeChanged() {
    const type = $('#schedulerType').find('option:selected').val();
    if (type === 'free') {
        $('#free-scheduler').show();
    } else {
        $('#free-scheduler').hide();
    }
}

function intervalChanged() {
    const interval = $('#interval').find('option:selected').val();
    if (interval === '5') {
        $('#endMinute').val('55');
    } else if (interval === '15') {
        $('#endMinute').val('45');
    } else if (interval === '30') {
        $('#endMinute').val('30');
    } else if (interval === '60') {
        $('#endMinute').val('00');
    }
}
function fromToFetchChanged() {
    const sel = $('#fromToFetch').find('option:selected').val();
    if (sel === 'true') {
        $('#fromDate_field').show();
    } else {
        $('#fromDate_field').hide();
    }
}

$(document).ready(function () {
    $('#select_all_button').click(function () {
        selectAllDays(true);
    });
    $('#select_weekdays_button').click(function () {
        selectAllDays(false);
    });

    $('#select_all_month_button').click(function () {
        selectAllMonths();
    });
    $('#select_all_quarter_button').click(function () {
        selectQuarters();
    });

    $('#bankId').change(checkEbicsVersionOfBank).change(updateUserFields).change().change(bankChanged);
    $('#schedulerType').change(schedulerTypeChanged).change();
    $('#onceADay').change(repeatOptionChanged).change();
    $('#weekOrMonth').change(executionTypeOptionChanged).change();
    $('#interval').change(intervalChanged);
    $('#fromToFetch').change(fromToFetchChanged);

    $('input#exportDir').on('change keyup focusout', function () {
        const exampleField = $('#exportDir-example');
        const exportDirField = $('#exportDir');
        $.ajax({
            url: exampleField.data('linktemplate') + encodeURIComponent(this.value),
            success: function (result) {
                exportDirField.removeClass('is-invalid');
                exampleField.removeClass('invalid-feedback')
                exampleField.text(exampleField.data('successmessage') + ' "' + result + '"');
            },
            error: function (result) {
                switch (result.responseText) {
                    case 'noPattern':
                        exportDirField.removeClass('is-invalid');
                        exampleField.removeClass('invalid-feedback')
                        exampleField.text('');
                        break;
                    case 'incorrectPattern':
                        exportDirField.addClass('is-invalid');
                        exampleField.addClass('invalid-feedback')
                        exampleField.text(exampleField.data('incorrectpatternmessage'));
                        break;
                    default:
                        exportDirField.addClass('is-invalid');
                        exampleField.addClass('invalid-feedback')
                        exampleField.text(exampleField.data('patternerrormessage'));
                        break;
                }
            }
        });
    });

    intervalChanged();
    $('#startMinute').attr("disabled",true);
    $('#endMinute').attr("disabled",true);

    if ($('#edit_button').length > 0) {
        $('#dailyMins').attr("disabled", true);
    }

    $('#fetch_button').click(function () {
        $('#fetch-schedule-form').submit();
    });
    fromToFetchChanged();
});
