/**
 * Parameters for the current script
 * @type {
 *     {getEditModeUrl : string},
 *     {getUpdateLicenseUrl : string},
 *     {getResetUserPasswordUrl : string},
 *     {getLockLoginUrl : string},
 *     {getUnLockLoginUrl : string},
 *     {getEditUrl : string},
 *     {activeBankUsersWithKeys : [
 *         {bankId : string}
 *     ]}
 * }
 */
const bankDetailsJs = $('#edituser_js');
const bankDetailsParams = JSON.parse(atob(bankDetailsJs.attr('data-params')));

function replaceEditLink(e) {
    // need to change link if another tab is selected. If an action will be executed the redirect will open the correct open tab again.
    let tab = $(e.target).attr("id").replace("-tab", "");
    $('#edit_button').attr("href", bankDetailsParams.getEditModeUrl.replace("TAB", tab));
    $('#license-update-button').attr("href", bankDetailsParams.getUpdateLicenseUrl.replace("TAB", tab));
    $('#reset-user-button').attr("href", bankDetailsParams.getResetUserPasswordUrl.replace("TAB", tab));
    $('#lock-user-button').attr("href", bankDetailsParams.getLockLoginUrl.replace("TAB", tab));
    $('#unlock_user').attr("href", bankDetailsParams.getUnlockLoginUrl.replace("TAB", tab));
    $('#no_edit_button').attr("href", bankDetailsParams.getEditUrl.replace("TAB", tab));
}

function bankCheckboxChanged() {
    let userBankRemoved = false;

    bankDetailsParams.activeBankUsersWithKeys.forEach(function (userEntry) {
        let bankId = userEntry.bankId;
        if (!$('#banks_' + bankId).prop('checked')) {
            userBankRemoved = true;
        }
    });

    if (userBankRemoved === true) {
        $('#flashRemovingBankDeletesKeys').show();
    } else {
        $('#flashRemovingBankDeletesKeys').hide();
    }
}

$(document).ready(function () {
    //change edit link if another tab is open
    $('#tabgeneral-tab').on('show.bs.tab', function (e) {
        replaceEditLink(e);
    });
    $('#tabpermissions-tab').on('show.bs.tab', function (e) {
        replaceEditLink(e);
    });
    $('#tabbanks-tab').on('show.bs.tab', function (e) {
        replaceEditLink(e);
    });
    $('#tabaccounts-tab').on('show.bs.tab', function (e) {
        replaceEditLink(e);
    });

    // Show warning flash when removing an active bank
    $('input[id^=banks_][type=checkbox]').change(bankCheckboxChanged);
    $('#flashRemovingBankDeletesKeys').hide();
});
