/**
 * Parameters for the current script
 * @type {
 *     {numberOfTenants : int},
 *     {allowRecipientRecording : boolean},
 *     {filterActive : boolean},
 *     {deleteMessage : {
 *         none : string,
 *         single : string,
 *         multiple : string
 *     }}
 * }
 */
const recipientsParams = JSON.parse(atob($('#recipients_js').data('params')));

function checkboxCallback(numSelected) {
    if (numSelected) {
        if (recipientsParams.allowRecipientRecording) {
            $('#actions_menu_delete').removeClass('disabled disabled-menu-item');
            $('#actions_menu_duplicate_link').removeClass('disabled disabled-menu-item');
            if (numSelected === 1) {
                $('#delete_prepare_question_text').html(recipientsParams.deleteMessage.single);
            } else {
                $('#delete_prepare_question_text').html(recipientsParams.deleteMessage.multiple
                    .replace('999', numSelected));
            }
        }
        $('#actions_menu_export_link').removeClass('disabled disabled-menu-item');
    } else {
        if (recipientsParams.allowRecipientRecording) {
            $('#actions_menu_delete').addClass('disabled disabled-menu-item');
            $('#actions_menu_duplicate_link').addClass('disabled disabled-menu-item');
            $('#delete_prepare_question_text').html(recipientsParams.deleteMessage.none);
        }
        $('#actions_menu_export_link').addClass('disabled disabled-menu-item');
    }

    const selection = getSelectedIds('recipientsTable_select');
    if (recipientsParams.allowRecipientRecording) {
        setHiddenFormTextParameter($('#recipients_delete_form'), selection);
        setHiddenFormTextParameter($('#recipients_duplicate_form'), selection);
    }
    setHiddenFormTextParameter($('#recipients_export_form'), selection);
}

$(document).ready(function () {
    $('#actions_menu_duplicate').click(function () {
        if (recipientsParams.numberOfTenants > 1) {
            $('#recipients_duplicate_modal').modal('show');
        } else {
            $('#recipients_duplicate_form').submit();
        }
    });
    $('#actions_menu_export_link').click(function () {
        $('#recipients_export_form').submit();
    });
    $('#actions_menu_export').click(function () {
        $('#recipients_export_form').submit();
    });
    if (recipientsParams.filterActive) {
        $('#filter_reset_button').click(function () {
            $('#filter_modal input[name!="csrfToken"]').val('');
        });
    }
});