function periodParameterChanged() {
    let url = $('#periodicparameters_js').attr('data-findperiodsurl');
    url = url.replace(/amp;/g, '');
    url = url.replace('FIRST', $('#firstExecution').val());
    url = url.replace('PREVIOUS', $('#previousExecution').val());
    url = url.replace('NEXT', $('#nextExecution').val());
    url = url.replace('INTERVAL', $('#executionInterval').val());
    url = url.replace('999', $('#executionCount').val());

    $.ajax({
        url: url,
        mimeType: 'text/plain',
        dataType: 'text',
        success: function (response) {
            const dates = response.split('\t');
            if (dates == null || dates.length < 3) {
                return;
            }

            $('#firstExecution').val(dates[0]);
            $('#nextExecution').val(dates[1]);
            $('#lastExecution').val(dates[2]);
        },
        error: function (error) {
            console.log(error);
        }
    });
}

$(document).ready(function () {
    $('#firstExecution').change(periodParameterChanged).keyup(periodParameterChanged);
    $('#executionInterval').change(periodParameterChanged);
    $('#executionCount').change(periodParameterChanged).keyup(periodParameterChanged);
    $('#nextExecution').change(periodParameterChanged).keyup(periodParameterChanged).change();
});
