/**
 * Parameters for the current script
 * @type {
 *     {saveAsPeriodicLink : String},
 *     {saveAsTemplateLink : String},
 *     {signMessage : String},
 *     {reallyDeleteMessage : {
 *         none : String,
 *         single : String,
 *         multiple : String
 *     }},
 *     {modifyPaymentsTitle : {
 *         none : String,
 *         single : String,
 *         multiple : String
 *     }},
 *     {paymentInfos : [
 *         {id : number},
 *         {amount : String},
 *         {currency : String}
 *     ]},
 *     {showSignPrepareModal : Boolean},
 *     {addDecimalsUrl : String}
 * }
 */
const openpaymentsParams = JSON.parse(atob($('#openpayments_js').attr('data-params')));

function checkboxCallback(numSelected) {
    const signButton = $('#openpayments_navbar_sign');
    let title = $('#actions_menu_movetofolder').children('span')[0].getAttribute("data-bs-original-title");
    // if a title was set "no folders were created." disabled should not be removed
    let enableMoveToFolder = title === null || title.length === 0;
    if (numSelected) {
        signButton.removeClass('disabled disabled-menu-item');
        signButton.html('<span class="fa fa-check bl-button-icon"></span>'
            + openpaymentsParams.signMessage + '&nbsp;<span class="badge">' +
            Math.min(numSelected, openpaymentsParams.paymentInfos.length) + '</span>');
        $('#actions_menu_save_link').removeClass('disabled disabled-menu-item');
        $('#actions_menu_delete_link').removeClass('disabled disabled-menu-item');
        $('#actions_menu_duplicate_link').removeClass('disabled disabled-menu-item');
        if (enableMoveToFolder) {
            $('#actions_menu_movetofolder_link').removeClass('disabled disabled-menu-item');
        }
        $('#actions_menu_modifypayments_link').removeClass('disabled disabled-menu-item');
        if (numSelected === 1) {
            $('#actions_menu_saveas_periodic_link').removeClass('disabled disabled-menu-item');
            $('#actions_menu_saveas_template_link').removeClass('disabled disabled-menu-item');
        } else {
            $('#actions_menu_saveas_periodic_link').addClass('disabled disabled-menu-item');
            $('#actions_menu_saveas_template_link').addClass('disabled disabled-menu-item');
        }
        $('#actions_menu_print_link').removeClass('disabled disabled-menu-item');
    } else {
        signButton.addClass('disabled disabled-menu-item');
        signButton.html('<span class="fa fa-check bl-button-icon"></span>'
            + openpaymentsParams.signMessage);
        $('#actions_menu_save_link').addClass('disabled disabled-menu-item');
        $('#actions_menu_delete_link').addClass('disabled disabled-menu-item');
        $('#actions_menu_duplicate_link').addClass('disabled disabled-menu-item');
        $('#actions_menu_movetofolder_link').addClass('disabled disabled-menu-item');
        $('#actions_menu_modifypayments_link').addClass('disabled disabled-menu-item');
        $('#actions_menu_saveas_periodic_link').addClass('disabled disabled-menu-item');
        $('#actions_menu_saveas_template_link').addClass('disabled disabled-menu-item');
        $('#actions_menu_print_link').addClass('disabled disabled-menu-item');
    }

    if (numSelected === 0) {
        $('#delete_prepare_question_text').html(openpaymentsParams.reallyDeleteMessage.none);
        $('#actions_menu_modifypayments_link').html(
            '<span class="bl-action-menu-icon fa fa-paste"></span>' +
            openpaymentsParams.modifyPaymentsTitle.none);
        $('#modify_payments_modal_title').html(openpaymentsParams.modifyPaymentsTitle.none);
    } else if (numSelected === 1) {
        $('#delete_prepare_question_text').html(openpaymentsParams.reallyDeleteMessage.single);
        $('#actions_menu_modifypayments_link').html(
            '<span class="bl-action-menu-icon fa fa-paste"></span>' +
            openpaymentsParams.modifyPaymentsTitle.single);
        $('#modify_payments_modal_title').html(openpaymentsParams.modifyPaymentsTitle.single);
    } else {
        $('#delete_prepare_question_text').html(
            openpaymentsParams.reallyDeleteMessage.multiple.replace('999', numSelected));
        $('#actions_menu_modifypayments_link').html(
            '<span class="bl-action-menu-icon fa fa-paste"></span>' +
            openpaymentsParams.modifyPaymentsTitle.multiple);
        $('#modify_payments_modal_title').html(openpaymentsParams.modifyPaymentsTitle.multiple);
    }

    const selectedIds = getSelectedIds('paymentsTable_select');
    setHiddenFormTextParameter($('#openpayments_sign_form'), selectedIds);
    setHiddenFormTextParameter($('#openpayments_save_form'), selectedIds);
    setHiddenFormTextParameter($('#openpayments_duplicate_form'), selectedIds);
    setHiddenFormTextParameter($('#delete_prepare_question_form'), selectedIds);
    setHiddenFormTextParameter($('#folder_select_form'), selectedIds, 'paymentIds');
    setHiddenFormTextParameter($('#modify_payments_form'), selectedIds, 'paymentIds');
    setHiddenFormTextParameter($('#openpayments_print_form'), selectedIds);
    setHiddenFormTextParameter($('#openpayments_printoverview_form'), selectedIds);
    setHiddenFormTextParameter($('#openpayments_exportoverview_form'), selectedIds);
    setHiddenFormTextParameter($('#openpayments_fixandpreparesign_form'), selectedIds);

    if (numSelected === 1) {
        $('#payment_template_name_form').attr(
            'action', openpaymentsParams.saveAsTemplateLink.replace('999', selectedIds).replace(
                /amp;/g, ''));
        $('#periodic_parameters_form').attr(
            'action', openpaymentsParams.saveAsPeriodicLink.replace('999', selectedIds).replace(
                /amp;/g, ''));
    } else {
        $('#periodic_parameters_form').removeAttr('action');
        $('#payment_template_name_form').removeAttr('action');
    }
    updateSelectionInfo();
}

function updateSelectionInfo() {
    let numberOfSelectedPayments = 0;
    let id;
    const data = [];
    getSelectedPaymentCheckboxes().each(function () {
        id = parseInt($(this).attr('id').substring(21));
        numberOfSelectedPayments++;
        openpaymentsParams.paymentInfos.forEach(function (paymentInfo) {
            if (id === paymentInfo.id) {
                if(paymentInfo.amount){
                    let currency = paymentInfo.currency;
                    if(currency == null){
                        currency='EUR';
                    }
                    let singleData = '' + paymentInfo.amount +'-'+currency;
                    data.push(singleData);
                }else {
                    data.push('');
                }
            }
        });
    });

    if (numberOfSelectedPayments > 1) {
        $.ajaxSetup({
            beforeSend: function (xhr) {
                xhr.setRequestHeader('Csrf-Token', $('input[name="csrfToken"]').attr('value'));
            }
        });
        let ajaxUrl = openpaymentsParams.addDecimalsUrl;
        $.ajax({
            url: ajaxUrl,
            data: JSON.stringify({data: data}),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            type: 'POST',
            success: function (result) {
                if (getNumberOfSelectedPayments() !== numberOfSelectedPayments) {
                    return; // this is an outdated ajax result, do not use it! (Bug 7082)
                }
                const resultAmountString = result.sum;
                if (resultAmountString) {
                    const selectionInfo = $('#selection_info');
                    selectionInfo.html(result.sum);
                    selectionInfo.show();
                }
            },
            error: function (result) {
                console.log(result)
            }
        });
    } else {
        $('#selection_info').hide();
    }
}

function modifyPaymentsOptionActivated(option) {
    const checkboxId = 'modify' + option.substring(0, 1).toUpperCase() + option.substring(1);
    if ($('#' + checkboxId).prop('checked')) {
        $('#' + option).show();
    } else {
        $('#' + option).hide();
    }
}

function getSelectedPaymentCheckboxes() {
    return $('input:checkbox[id^="paymentsTable_select_"]:not(#paymentsTable_select_all):checked');
}

function getNumberOfSelectedPayments() {
    return getSelectedPaymentCheckboxes().length;
}

$(document).ready(function () {
    if (openpaymentsParams.showSignPrepareModal) {
        $('#sign_prepare_question_modal').modal('show');
    }
    const numSelected = getNumberOfSelectedPayments();
    if (numSelected > 0) {
        checkboxCallback(numSelected);
    }

    $('#openpayments_navbar_sign').click(function () {
        $('#openpayments_sign_form').submit();
    });
    $('#actions_menu_save_link').click(function () {
        $('#openpayments_save_form').submit();
    });
    $('#actions_menu_duplicate_link').click(function () {
        $('#openpayments_duplicate_form').submit();
    });
    $('#actions_menu_print_link').click(function () {
        $('#openpayments_print_form').submit();
    });
    $('#actions_menu_printoverview_link').click(function () {
        $('#openpayments_printoverview_form').submit();
    });
    $('#actions_menu_exportoverview_link').click(function () {
        $('#openpayments_exportoverview_form').submit();
    });
    const modifyOriginatorAccountCheckbox = $('#modifyOriginatorAccount');
    if (!modifyOriginatorAccountCheckbox.is(':checked')) {
        $('#originatorAccount').hide();
    }
    modifyOriginatorAccountCheckbox.change(function () {
        modifyPaymentsOptionActivated('originatorAccount');
    });
    const modifyOriginatorCheckbox = $('#modifyOriginator');
    if (!modifyOriginatorCheckbox.is(':checked')) {
        $('#originator').hide();
    }
    modifyOriginatorCheckbox.change(function () {
        modifyPaymentsOptionActivated('originator');
    });
    const modifyPurposeCheckbox = $('#modifyPurpose');
    if (!modifyPurposeCheckbox.is(':checked')) {
        $('#purpose').hide();
    }
    modifyPurposeCheckbox.change(function () {
        modifyPaymentsOptionActivated('purpose');
    })
    const modifyExecutionDateCheckbox = $('#modifyExecutionDate');
    if (!modifyExecutionDateCheckbox.is(':checked')) {
        $('#executionDate').hide();
    }
    modifyExecutionDateCheckbox.change(function () {
        modifyPaymentsOptionActivated('executionDate');
    });
    updateSelectionInfo();
});
