/**
 * Parameters for the current script
 * @type {
 *     {deleteQuestion : {
 *         single : string,
 *         multiple : string,
 *         none : string
 *     }},
 *     {updateMessage : string},
 *     {fetchingDetailsMessage : string},
 *     {numberOfPayments : string},
 *     {totalAmount : string},
 *     {payee : string},
 *     {payer : string},
 *     {account : string},
 *     {purpose : string},
 *     {reason : string},
 *     {customer : string},
 *     {bank : string},
 *     {status : string},
 *     {hac : {
 *         user : string,
 *         action : string,
 *         message : string,
 *         additional : string
 *     }},
 *     {updateUrl : string},
 *     {fetchDetailsUrl : string},
 *     {indexUrl : string}
 * }
 */
const notificationsParams = JSON.parse(atob($('#notifications_js').data('params')));

function checkboxCallback(itemSelected) {
    if (itemSelected) {
        $('#notifications_delete_button').removeClass('disabled  disabled-menu-item');
    } else {
        $('#notifications_delete_button').addClass('disabled  disabled-menu-item');
    }

    if (itemSelected === 0) {
        $('#notifications_delete_question').html(notificationsParams.deleteQuestion.none);
    } else if (itemSelected === 1) {
        $('#notifications_delete_question').html(notificationsParams.deleteQuestion.single);
    } else {
        $('#notifications_delete_question').html(notificationsParams.deleteQuestion.multiple.replace(
            '999', '' + itemSelected));
    }

    setHiddenFormTextParameter($('#notifications_delete_form'), getSelectedIds('notifications_table_select'));
}

function fetchNotifications() {
    const fetchButton = $('#navbar_fetch_button');
    fetchButton.addClass('disabled disabled-menu-item');
    fetchButton.html('<span class="fa fa-spinner fa-spin-pulse bl-action-menu-icon"></span>' + notificationsParams.updateMessage);

    $.ajax({
        url: notificationsParams.updateUrl,
        cache: false,
        success: function () {
            $(location).attr('href', notificationsParams.indexUrl)
        },
        error: function (error) {
            console.log(error);
        }
    })
}

function createTableRowIfNotEmpty(tbody, label, info) {
    if (info == null || info === '') {
        return;
    }

    const tr = createHtmlElement(tbody, 'TR');
    createHtmlElement(tr, 'TD').html(label);
    createHtmlElement(tr, 'TD').html(info);
}

function createCallbackNotificationPanel(parent, callback) {
    const panel = createHtmlElement(parent, 'DIV', 'card mb-3');
    createHtmlElement(panel, 'DIV', 'card-header').html(callback['msgid']);

    const panelBody = createHtmlElement(panel, 'DIV', 'card-body');
    const table = createHtmlElement(panelBody, 'TABLE', 'table table-condensed borderless description-table');
    const tbody = createHtmlElement(table, 'TBODY');

    createTableRowIfNotEmpty(tbody, notificationsParams.bank, callback['bank']);
    createTableRowIfNotEmpty(tbody, notificationsParams.customer, callback['customer']);
    createTableRowIfNotEmpty(tbody, notificationsParams.status, callback['status']);

    if (callback['logicalfiles'] != null) {
        callback['logicalfiles'].forEach(function (logicalfile) {
            createHtmlElement(panelBody, 'DIV').html(logicalfile.statusmessage);
        })
    }
    if (callback['transactionsmsg'] != null) {
        createHtmlElement(panelBody, 'DIV').html(callback['transactionsmsg']);
        let list = createHtmlElement(panelBody, 'UL');
        callback['transactions'].forEach(function (transaction) {
            createHtmlElement(list, 'LI').html(transaction.summaryinfos);
        })
    }
}

function createNotificationOrderPanel(parent, order) {
    const panel = createHtmlElement(parent, 'DIV', 'card mb-3');
    createHtmlElement(panel, 'DIV', 'card-header').html(order['msgid']);

    const panelBody = createHtmlElement(panel, 'DIV', 'card-body');
    const table = createHtmlElement(panelBody, 'TABLE', 'table table-condensed borderless description-table');
    const tbody = createHtmlElement(table, 'TBODY');

    createTableRowIfNotEmpty(tbody, notificationsParams.numberOfPayments, order['pmtnumber']);
    createTableRowIfNotEmpty(tbody, notificationsParams.totalAmount, order['amount']);
    createTableRowIfNotEmpty(tbody, notificationsParams.payee, order['payee']);
    createTableRowIfNotEmpty(tbody, notificationsParams.payer, order['payer']);
    createTableRowIfNotEmpty(tbody, notificationsParams.account, order['recipientacc']);
    createTableRowIfNotEmpty(tbody, notificationsParams.purpose, order['purpose']);

    if (order['reasons'] != null) {
        let label = notificationsParams.reason;
        order['reasons'].forEach(function (reason) {
            createTableRowIfNotEmpty(tbody, label, reason.reason);
            label = '';
        })
    }
}

function createHacPanel(parent, hac) {
    const panel = createHtmlElement(parent, 'DIV', 'card mb-3');
    createHtmlElement(panel, 'DIV', 'card-header').html(hac['time']);

    const panelBody = createHtmlElement(panel, 'DIV', 'card-body');
    const table = createHtmlElement(panelBody, 'TABLE', 'table table-condensed borderless description-table');
    const tbody = createHtmlElement(table, 'TBODY');

    createTableRowIfNotEmpty(tbody, notificationsParams.hac.user, hac['user']);
    createTableRowIfNotEmpty(tbody, notificationsParams.hac.action, hac['axn']);
    createTableRowIfNotEmpty(tbody, notificationsParams.hac.message, hac['rsn']);

    if (hac['addtnl'] != null && hac['addtnl'] !== '') {
        createHtmlElement(panelBody, 'LABEL').html(notificationsParams.hac.additional);
        createHtmlElement(panelBody, 'PRE', 'bl-pre-ticket').html(hac['addtnl']);
    }
}

function createErrorNotificationPanel(parent, id, title, message, hacs, ptks) {
    const result = createHtmlElement(parent, 'DIV');
    if (title != null) {
        $('#notification_modal_' + id + '_title').html(title);
    }
    if (message != null) {
        createHtmlElement(result, 'P').html(message);
    }
    if (hacs != null) {
        hacs.forEach(function (hac) {
            createHacPanel(result, hac);
        });
    }
    if (ptks != null) {
        const pre = createHtmlElement(result, 'PRE', 'bl-pre-ticket');
        ptks.forEach(function (ptk) {
            if ($(pre).html().length > 0) {
                $(pre).append('<BR>');
            }
            $(pre).append(ptk['ptk']);
        });
    }
}

function fetchDetails(modalId, notificationId) {
    const detailsDiv = $('#notification_details_info_' + modalId);
    if (detailsDiv == null || !detailsDiv.length || (detailsDiv.html() != null && detailsDiv.html() !== '')) {
        return;
    }

    detailsDiv.html(notificationsParams.fetchingDetailsMessage);

    $.ajax({
        url: notificationsParams.fetchDetailsUrl.replace('999', notificationId),
        mimeType: 'application/json',
        dataType: 'json',
        success: function (details) {
            detailsDiv.html('');

            if (details['orders'] != null) {
                details['orders'].forEach(function (order) {
                    createNotificationOrderPanel(detailsDiv, order);
                });
            }
            if (details['logicalfiles'] != null) {
                createCallbackNotificationPanel(detailsDiv, details);
            }
            if (details['message'] != null) {
                createErrorNotificationPanel(detailsDiv, modalId, details['title'], details['message'], details['hacs'], details['ptks']);
            }
        },
        error: function (error) {
            console.log(error);
        }
    });
}

$(document).ready(function () {
    $('#navbar_fetch_button').click(fetchNotifications);
    $('div[id^=notification_modal_]').each(function () {
        const id = parseInt($(this).attr('id').substring(19));
        if (isNaN(id)) {
            return;
        }
        $('#notification_modal_' + id).on('shown.bs.modal', function () {
            fetchDetails(id, $(this).data('notification-id'));
        });
    });
    $('tr[id^=notifications_table_row_]').click(function () {
        var hrefAttr = $(this).attr('href');
        if (typeof hrefAttr === 'undefined' || hrefAttr === false) {
            $('#notification_modal_' + $(this).data('rownumber')).modal('show');
        }
    });
});
