/**
 * Parameters for the current script
 * @type {
 *     {signMessage : string},
 *     {deleteMessage : string},
 *     {deleteTitle : {
 *         single : string,
 *         multiple : string,
 *         none : string
 *     }},
 *     {deleteQuestion : {
 *         single : string,
 *         multiple : string,
 *         none : string
 *     }},
 *     {uploadMessage : string},
 *     {uploadLink : string},
 *     {files : [
 *         {id : number},
 *         {info : string}
 *     ]}
 * }
 */
const folderfilesParams = JSON.parse(atob($('#folderfiles_js').attr('data-params')));

function checkboxCallback(numSelected) {
    const folderFilesSignButton = $('#folders_files_sign_button');
    const folderFilesDeleteButton = $('#folders_files_delete_button');
    if (numSelected === 0) {
        folderFilesSignButton.addClass('disabled disabled-menu-item');
        folderFilesSignButton.html('<span class="fa fa-check bl-button-icon"></span>' +
            folderfilesParams.signMessage);
        folderFilesSignButton.click('');
        folderFilesDeleteButton.addClass('disabled disabled-menu-item');
        folderFilesDeleteButton.html('<span class="fa fa-check bl-button-icon"></span>' +
            folderfilesParams.deleteMessage);

        $('#folder_files_delete_modal_title').html(folderfilesParams.deleteTitle.none);
        $('#folder_files_delete_question').html(folderfilesParams.deleteQuestion.none);
    } else {
        folderFilesSignButton.removeClass('disabled disabled-menu-item');
        folderFilesDeleteButton.removeClass('disabled disabled-menu-item');

        if (numSelected === 1) {
            $('#folder_files_delete_modal_title').html(folderfilesParams.deleteTitle.single);
            $('#folder_files_delete_question').html(folderfilesParams.deleteQuestion.single);
        } else {
            $('#folder_files_delete_modal_title').html(folderfilesParams.deleteTitle.multiple.replace(
                '999', '' + numSelected));
            $('#folder_files_delete_question').html(folderfilesParams.deleteQuestion.multiple.replace(
                '999', '' + numSelected));
        }

        let selection = '';
        if (folderfilesParams.files != null && folderfilesParams.files.length > 0) {
            selection = '(';
            let id;
            $('input[id^=folder_files_select]:not(#folder_files_select_all):checked').each(function () {
                id = parseInt($(this).attr('id').substring(20));
                folderfilesParams.files.forEach(function (file) {
                    if (id === file.id) {
                        if (selection !== '(') {
                            selection += '),(';
                        }
                        selection += file.info;
                    }
                });
            });
            selection += ')';
        }
        const folderFilesSignForm = $('#folder_files_sign_form');

        setHiddenFormTextParameter(folderFilesSignForm, selection);
        folderFilesSignButton.html('<span class="fa fa-check bl-button-icon"></span>' +
            folderfilesParams.signMessage + '&nbsp;<span class="badge">' + numSelected + '</span>');
        folderFilesSignButton.click(function () {
            folderFilesSignForm.submit()
        });

        setHiddenFormTextParameter($('#folder_files_delete_form'), selection);
        folderFilesDeleteButton.html('<span class="fa fa-check bl-button-icon"></span>' +
            folderfilesParams.deleteMessage + '&nbsp;<span class="badge">' + numSelected + '</span>');
    }
}

$(document).ready(function () {
    setupDropzone(folderfilesParams.uploadMessage, folderfilesParams.uploadLink);
});