/**
 * Parameters for the current script
 * @type {
 *     {deleteMessage : {
 *         none : string,
 *         single : string,
 *         multiple : string
 *     }}
 * }
 */
const fetchedParams = JSON.parse(atob($('#fetched_js').attr('data-params')));

function checkboxCallback(itemSelected) {
    if (!itemSelected) {
        $('#delete_button').addClass('disabled disabled-menu-item');
        $('#zipfile_link').addClass('disabled disabled-menu-item');
        $('#restart_postprocessing_link').addClass('disabled disabled-menu-item');
    } else {
        $('#delete_button').removeClass('disabled disabled-menu-item');
        $('#zipfile_link').removeClass('disabled disabled-menu-item');
        $('#restart_postprocessing_link').removeClass('disabled disabled-menu-item');
    }

    if (itemSelected === 0) {
        $('#delete_question').html(fetchedParams.deleteMessage.none);
    } else if (itemSelected === 1) {
        $('#delete_question').html(fetchedParams.deleteMessage.single);
    } else {
        $('#delete_question').html(fetchedParams.deleteMessage.multiple.replace('999', itemSelected));
    }

    const selection = getSelectedIds('fetchedTable_select');
    setHiddenFormTextParameter($('#delete_prepare_question_form'), selection);
    setHiddenFormTextParameter($('#zipfile_form'), selection);
    setHiddenFormTextParameter($('#reprocess_form'), selection);
}

$(document).ready(function () {
    checkboxCallback(0);
    $('tr[id^=fetchedTable_row_]').click(function () {
        $('#fetch_details_modal_' + $(this).data("rownumber")).modal('show');
    });

    $('#zipfile_link').click(function() {
        $('#zipfile_form').submit();
    });
    $('#restart_postprocessing_link').click(function() {
        $('#reprocess_form').submit();
    });

    $('[id^=restart_postprocessing_link_]').each(function() {
        let buttonId = $(this).attr('id');
        let fetchId = buttonId.substring(buttonId.lastIndexOf('_') + 1);
        setHiddenFormTextParameter($('#reprocess_form_' + fetchId), fetchId);
        $(this).click(function() {
            $('#reprocess_form_' + fetchId).submit();
        })
    });
});
