const fetchordertypefield_js = $('#fetchordertypefield_js');
const bankOrderTypeKeys = [];
const bankOrderTypes = [];

function loadOrderTypes() {
    if (fetchordertypefield_js.attr('data-banks') == null) {
        return;
    }
    fetchordertypefield_js.attr('data-banks').split(',').forEach(function (bankId) {
        bankOrderTypeKeys[bankId] = fetchordertypefield_js.data('ordertypes-' + bankId).split(',');
        if (bankOrderTypeKeys[bankId] == null) {
            return;
        }
        bankOrderTypes[bankId] = [];
        bankOrderTypeKeys[bankId].forEach(function (orderType) {
            bankOrderTypes[bankId][orderType] = fetchordertypefield_js.data(
                'ordertype-' + bankId + '-' + orderType.toLowerCase());
        });
    });
}

function bankChanged() {
    const bank = $('#' + fetchordertypefield_js.data('bankfieldid')).find('option:selected').val();
    const orderTypeMenu = $('#order_type_menu');
    orderTypeMenu.empty();

    let option;
    let link;
    bankOrderTypeKeys[bank].forEach(function (key) {
        option = createHtmlElement(orderTypeMenu, 'LI');
        link = createHtmlElement(option, 'A', 'dropdown-item')
        $(link).click(function () {
            updateOrderType(key);
        }).attr('role', 'button');
        if (bankOrderTypes[bank][key].length > 52) {
            $(link).html(bankOrderTypes[bank][key].substring(0, 50) + '&hellip;');
            $(link).attr('data-toggle', 'tooltip');
            $(link).attr('title', bankOrderTypes[bank][key]);
        } else {
            $(link).html(bankOrderTypes[bank][key]);
        }
    });
}

function updateOrderType(orderType) {
    $('#' + fetchordertypefield_js.data('ordertypefieldid')).val(orderType);
    $('#order_type_search').hide();
}

function searchOrderTypes() {
    let search = $('#' + fetchordertypefield_js.data('ordertypefieldid')).val();
    const orderTypeSearchBox = $('#order_type_search');
    if (search == null || search.length === 0) {
        orderTypeSearchBox.hide();
        return;
    }
    search = search.toLowerCase();

    const bank = $('#' + fetchordertypefield_js.data('bankfieldid')).find('option:selected').val();
    const result = [];
    bankOrderTypeKeys[bank].forEach(function (key) {
        if (result.length >= 10) {
            return;
        }

        if (bankOrderTypes[bank][key].toLowerCase().indexOf(search) >= 0) {
            result.push(key);
        }
    });

    if (result.length === 0) {
        orderTypeSearchBox.hide();
    } else {
        orderTypeSearchBox.empty();

        const div = createHtmlElement(orderTypeSearchBox, 'DIV', 'list-group');
        let link;
        result.forEach(function (key) {
            link = createHtmlElement(div, 'A');
            $(link).click(function () {
                updateOrderType(key);
            });
            $(link).addClass('list-group-item');
            $(link).prop('role', 'button');
            $(link).html(bankOrderTypes[bank][key]);
            // prevent all list items from closing menu on click
            $(link).mousedown(function (event) {
                event.preventDefault();
            });
        });
        orderTypeSearchBox.css('zIndex', '1000');
        orderTypeSearchBox.show();

        // prevent all list items from closing menu on click
        orderTypeSearchBox.children('a').click(function (event) {
            event.stopPropagation();
        });
    }
}

$(document).ready(function () {
    loadOrderTypes();
    $('a[id^=fetchordertype_select_]').click(function () {
        updateOrderType($(this).attr('id').substr(22));
    });
    $('#' + fetchordertypefield_js.data('ordertypefieldid')).keyup(function (event) {
        searchFieldKeyHandler(event, 'order_type_search', searchOrderTypes);
    }).focusout(function () {
        $('#order_type_search').hide();
    });
    $('[data-toggle="tooltip"]').tooltip();
    addSearchBoxEnterPrevention(fetchordertypefield_js.data('ordertypefieldid'));
    bankChanged();
});