$(document).ready(function () {
    const js = $('#pdfstatementsexportform_js');
    $('input#pattern').on('change keyup focusout', function () {
        const patternField = $('#pattern');
        const exampleField = $('#pattern-example');
        $.ajax({
            url: js.data('samplelinktemplate') + encodeURIComponent(this.value),
            success: function (result) {
                patternField.removeClass('is-invalid');
                exampleField.removeClass('invalid-feedback');
                exampleField.text(js.data('sampletemplate') + ' "' + result + '"');
            },
            error: function (result) {
                switch (result.responseText) {
                    case 'noPattern':
                        patternField.removeClass('is-invalid');
                        exampleField.removeClass('invalid-feedback');
                        exampleField.text('');
                        break;
                    case 'incorrectPattern':
                        patternField.addClass('is-invalid');
                        exampleField.addClass('invalid-feedback');
                        exampleField.text(js.data('incorrectpattern'));
                        break;
                    default:
                        patternField.addClass('is-invalid');
                        exampleField.addClass('invalid-feedback');
                        exampleField.text(js.data('patternerror'));
                        break;
                }
            }
        });
    }).change();
});