function checkboxCallback(itemSelected) {
    const selection = getSelectedIds('bookingsTable_select');
    const printButton = $('#print_button');
    const createAwvButton = $('#create_awv_button');
    const createSepaButton = $('#create_sepa_button');
    if (itemSelected) {
        printButton.click(function () {
            $('#print_selection_form').submit();
        });
        printButton.removeAttr('data-bs-toggle');
        printButton.removeAttr('data-bs-target');
        createAwvButton.removeClass('disabled disabled-menu-item');
        createSepaButton.removeClass('disabled disabled-menu-item');
        if (itemSelected === 1) {
            createSepaButton.html(
                '<span class="fa-solid fa-share-from-square bl-button-icon"></span>' + createSepaButton.data('titlesingular'));
            createAwvButton.html(
                '<span class="fa fa-map-signs bl-button-icon"></span>' + createAwvButton.data('titlesingular'));
        } else {
            createAwvButton.html(
                '<span class="fa fa-map-signs bl-button-icon"></span>' + createAwvButton.data('titleplural'));
            createSepaButton.html(
                '<span class="fa-solid fa-share-from-square bl-button-icon"></span>' + createSepaButton.data('titleplural'));
        }
        setHiddenFormTextParameter($('#export-form'), selection, 'exportIds');
        setHiddenFormTextParameter($('#markasread_form'), selection, 'bookingIds');
    } else {
        printButton.off('click');
        printButton.attr('data-bs-toggle', 'modal');
        printButton.attr('data-bs-target', '#print_confirm_modal');
        createAwvButton.addClass('disabled disabled-menu-item');
        createSepaButton.addClass('disabled disabled-menu-item');
        setHiddenFormTextParameter($('#export-form'), "", 'exportIds');
        setHiddenFormTextParameter($('#markasread_form'), getAllIds('bookingsTable_select'), 'bookingIds');
    }
    setHiddenFormTextParameter($('#print_selection_form'), selection);
    setHiddenFormTextParameter($('#create_awv_form'), selection);
    setHiddenFormTextParameter($('#create_sepa_form'), selection);

    const deleteQuestion = $('#export_prepare_message');
    let message;
    if (itemSelected === 0) {
        message = deleteQuestion.data('messageall');
    } else if (itemSelected === 1) {
        message = deleteQuestion.data('messageoneselected');
    } else {
        message = deleteQuestion.data('messagemultipleselected').replace('999', '' + itemSelected);
    }
    deleteQuestion.html(message);
}

$(document).ready(function () {
    $('#reset-button').click(function () {
        $('#filter-modal input[name!="csrfToken"]').val('');
        $('#filter-modal select').val(0).change();

        //remove feedbacks
        $('#filter-modal [id$="-feedback"]').remove();

        //remove is-invalid in classes
        let inputField = $('#filter-modal [class$="is-invalid"]');
        inputField.removeClass("is-invalid");
        inputField.children().removeClass("is-invalid");
    });

    if ($('#bookingview_js').data('showfiltermodal')) {
        $('#filter-modal').modal('show');
    }

    $('#print_button').click(function () {
        $('#print_selection_form').submit();
    });
    $('#export_button').click(function () {
        $('#exportoverview_form').submit();
    });

    $('#print_confirm_modal_yes').click(function () {
        $('#print_confirm_modal').modal('hide');
    });
    $('input[name=printradio]').change(function () {
        if ($(this).filter(':checked').val() === 'timerange') {
            $('#daterange-printDaterange input[type="text"]').removeAttr('disabled');
        } else {
            $('#daterange-printDaterange input[type="text"]').attr('disabled', 'true');
        }
    }).change();

    $('#bookings_export_submit').click(function () {
        $('#export_modal').modal('hide');
    });
    $('#cm_export_submit').click(function () {
        $('#export_single_modal').modal('hide');
    });

    $('#create_awv_button').click(function () {
        $('#create_awv_form').submit();
    });

    $('#create_sepa_button').click(function () {
        $('#create_sepa_form').submit();
    });

    $('tr[id^=bookingsTable_row_]').click(function () {
        $('#bookingsModal-' + $(this).data('rownumber')).modal('show');
    });
    $('tr[id^=bookingsTable_row_] > td:first-child, tr[id^=bookingsTable_row_] a').click(function (event) {
        event.stopPropagation();
    });
    $('#actions_menu_markasread').click(function () {
        $('#markasread_form').submit();
    });

    $('input[name=runexportsradio]').change(function () {
        if ($(this).filter(':checked').val() === 'all') {
            $('#daterange-runexportsDaterange input[type="text"]').attr('disabled', 'true');
        } else {
            $('#daterange-runexportsDaterange input[type="text"]').removeAttr('disabled');
        }
    });

    checkboxCallback(0);

    if($('#bookingview_js').data('selectedids')){
        /* loop ids and add attribute checked*/
        let str = $('#bookingview_js').data('selectedids');
        let str_array = str.split(',');
        for(var i = 0; i < str_array.length; i++) {
            // Trim the excess whitespace.
            str_array[i] = str_array[i].replace(/^\s*/, "").replace(/\s*$/, "");

            let cb = $('#bookingsTable_select_' + str_array[i]);
            cb.attr("checked","true");
        }

        checkboxCallback($('#bookingview_js').data('selectedids').split(", ").length);
    }

});
