function checkboxCallback(itemSelected) {
    if (isNaN(itemSelected)) {
        itemSelected = 0;
    }
    const selection = getSelectedIds('banksTable_select');

    const deleteButton = $('#banks_delete_button');
    if (deleteButton && deleteButton.length) {
        if (!itemSelected) {
            deleteButton.addClass("disabled disabled-menu-item");
        } else {
            deleteButton.removeClass("disabled disabled-menu-item");
        }
        setHiddenFormTextParameter($('#banks_delete_form'), selection);
    }

    const updateHtdButton = $('#banks_htdupdate_button');
    if (updateHtdButton && updateHtdButton.length) {
        if (!itemSelected) {
            updateHtdButton.addClass("disabled disabled-menu-item");
        } else {
            updateHtdButton.removeClass("disabled disabled-menu-item");
        }
        updateHtdButton.empty();
        createHtmlElement(updateHtdButton, 'SPAN', 'fa fa-refresh bl-button-icon',
            [{'aria-hidden': 'true'}]);
        if (itemSelected <= 1) {
            updateHtdButton.append(updateHtdButton.data('titlesingular'));
        } else {
            updateHtdButton.append(updateHtdButton.data('titleplural'));
        }
        setHiddenFormTextParameter($('#banks_htdupdate_form'), selection);

        const reiniLink = $('#banks_reini_link');
        const showIniletterLink = $('#banks_showini_link');
        const updateProtVersionLink = $('#banks_changeprotversion_link');
        const downgradeProtVersionLink = $('#banks_downgradeprotversion_link');
        const changeSigVersionLink = $('#banks_changesigversion_link');
        const lockBankLink = $('#banks_lockbank_link');
        if (itemSelected !== 1) {
            reiniLink.addClass("disabled disabled-menu-item");
            showIniletterLink.addClass("disabled disabled-menu-item");
            updateProtVersionLink.addClass("disabled disabled-menu-item");
            downgradeProtVersionLink.addClass("disabled disabled-menu-item");
            changeSigVersionLink.addClass("disabled disabled-menu-item");
            lockBankLink.addClass("disabled disabled-menu-item");

            reiniLink.removeAttr('href');
            showIniletterLink.removeAttr('href');
            updateProtVersionLink.removeAttr('href');
            downgradeProtVersionLink.removeAttr('href');
            changeSigVersionLink.removeAttr('href');
            lockBankLink.removeAttr('href');
        } else {
            changeSigVersionLink.removeClass("disabled disabled-menu-item");
            lockBankLink.removeClass("disabled disabled-menu-item");
            reiniLink.removeClass("disabled disabled-menu-item");
            showIniletterLink.removeClass("disabled disabled-menu-item");
            updateProtVersionLink.removeClass("disabled disabled-menu-item");
            downgradeProtVersionLink.removeClass("disabled disabled-menu-item");

            reiniLink.attr('href', reiniLink.data('linktemplate').replace('999', selection));
            showIniletterLink.attr('href', showIniletterLink.data('linktemplate').replace('999', selection));
            changeSigVersionLink.attr('href',
                changeSigVersionLink.data('linktemplate').replace('999', selection));
            lockBankLink.attr('href', lockBankLink.data('linktemplate').replace('999', selection));
            if (updateProtVersionLink.data('linktemplate')) {
                updateProtVersionLink.attr('href',
                    updateProtVersionLink.data('linktemplate').replace('999', selection));
            }
            if (downgradeProtVersionLink.data('linktemplate')) {
                downgradeProtVersionLink.attr('href',
                    downgradeProtVersionLink.data('linktemplate').replace('999', selection));
            }
        }

        const printHtdLink = $('#banks_printhtd_link');
        const activateBankLink = $('#banks_activate_link');
        const deactivateBankLink = $('#banks_deactivate_link');
        if (!itemSelected) {
            printHtdLink.addClass("disabled disabled-menu-item");
            activateBankLink.addClass("disabled disabled-menu-item");
            deactivateBankLink.addClass("disabled disabled-menu-item");
        } else {
            printHtdLink.removeClass("disabled disabled-menu-item");
            activateBankLink.removeClass("disabled disabled-menu-item");
            deactivateBankLink.removeClass("disabled disabled-menu-item");
        }
        setHiddenFormTextParameter($('#banks_print_htd_form'), selection);
        setHiddenFormTextParameter($('#banks_activate_form'), selection);
        setHiddenFormTextParameter($('#banks_deactivate_form'), selection);
    }
}

$(document).ready(function () {
    $('#banks_htdupdate_button').click(function () {
        $('#banks_htdupdate_form').submit()
    });
    $('#banks_delete_button').click(function () {
        $('#banks_delete_form').submit();
    });
    $('#banks_activate_button').click(function () {
        $('#banks_activate_form').submit();
    });
    $('#banks_deactivate_button').click(function () {
        $('#banks_deactivate_form').submit();
    });
    $('#banks_printhtd_button').click(function () {
        $('#banks_print_htd_form').submit();
    });
    checkboxCallback();
});