function replaceEntryId(formGroup, oldValue, newValue) {
    const oldValueString = '' + oldValue;
    const newValueString = '' + newValue;
    $(formGroup).find('[id]').each(function () {
        $(this).prop('id', $(this).prop('id').replace(oldValueString, '' + newValueString));
    });
    $(formGroup).find('[name]').each(function () {
        $(this).prop('name', $(this).prop('name').replace(oldValueString, newValueString));
    });
    $(formGroup).find('label[for]').each(function () {
        $(this).prop('for', $(this).prop('for').replace(oldValueString, newValueString));
    })
    $(formGroup).find('h4').each(function () {
        $(this).html($(this).data('template').replace('999', '' + (newValue + 1)));
    })
}

function addEntryPanel() {
    const entriesArea = $("#awv_dirinv_entries_area");
    const entryId = entriesArea.children().length;

    const formGroup = $('#awv_dirinv_entry_panel_template').children().first().clone();
    replaceEntryId(formGroup, 'XXXX', entryId);

    entriesArea.append(formGroup);

    setupEntryEventHandlers($('#entries_' + entryId + '_amount'), $('#awv_dirinv_entry_panel_delete_' + entryId));
}

function askToDeleteEntry(entryId) {
    const deleteModal = $('#awv_dirinv_entry_delete_modal');
    $(deleteModal).data('entry-id', entryId);
    $(deleteModal).modal('show');
}

function deleteEntry() {
    const deleteModal = $('#awv_dirinv_entry_delete_modal');
    const entryId = parseInt(deleteModal.data('entry-id'));
    deleteModal.removeData('entry-id');
    deleteModal.modal('toggle');

    $('#awv_dirinv_entry_panel_' + entryId).parents('div.row').first().remove();

    $('div[id^="awv_dirinv_entry_panel_"]').each(function () {
        const id = parseInt($(this).attr('id').substring('awv_dirinv_entry_panel_'.length));
        if (id > entryId) {
            replaceEntryId($(this), id, id - 1);
            $(this).attr('id', 'awv_dirinv_entry_panel_' + (id - 1));
        }
    });
}

function setupEntryEventHandlers(amountField, deleteButton) {
    $(amountField).change(function () {
        amountFieldChanged($(this));
    }).keydown(checkInputDecimalNumeric);
    $(deleteButton).click(function () {
        askToDeleteEntry($(this).attr('id').substring('awv_dirinv_entry_panel_delete_'.length));
    });
}

$(document).ready(function () {
    setupEntryEventHandlers($('input[id$="_amount"]'), $('button[id^=awv_dirinv_entry_panel_delete_]'));

    $('#awv_dirinv_add_entry_button').click(addEntryPanel);
    $('#awv_dirinv_entry_delete_ok_button').click(deleteEntry);

    if ($("#awv_dirinv_entries_area").children().length === 0) {
        addEntryPanel();
    }
})
