const js = $('#awvconvertnotificationsmodal_js');


function updateConversionLink(skipSelectUpdate) {
    let selection = js.data('entrytype')
    console.log(selection);
    console.log(js);
    const select = $('#awvnotifications_convert_select');
    if (!skipSelectUpdate) {
        select.empty();
        let options;
        if (selection === 'DIKA') {
            options = ['TRANSIT', 'DIRINV'];
        } else if (selection === 'TRANSIT') {
            options = ['DIKA', 'DIRINV'];
        } else if (selection === 'DIRINV') {
            options = ['DIKA', 'TRANSIT'];
        } else {
            options = [];
        }

        options.forEach(function (option) {
            createHtmlElement(select, 'OPTION', null, [{'value': option}]).html(
                select.data('entrytype-' + option.toLowerCase()));
        });
    }

    const convertButton = $('#awvnotifications_convert_button');
    convertButton.prop('href', convertButton.data('linktemplate').replace(
        'AWVTYPE', select.val()).replace(/amp;/g, ''));
}

$(document).ready(function () {
    updateConversionLink(false);
    $('#awvnotifications_convert_select').change(function () {
        updateConversionLink(true);
    });
});
