-- apply changes
create table recip_filter (
  id                            number(10) not null,
  user_id                       number(10) not null,
  payment_type                  number(10),
  payment_type_comp             number(10),
  vop_result                    varchar2(4),
  vop_result_comp               number(10),
  text                          varchar2(255),
  text_comp                     number(10),
  from_last_usage               date,
  to_last_usage                 date,
  last_usage_comp               number(10),
  constraint ck_recip_filter_payment_type check ( payment_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15)),
  constraint ck_rcp_fltr_pymnt_typ_cmp check ( payment_type_comp in (0,1)),
  constraint ck_rcp_fltr_vp_rslt_cmp check ( vop_result_comp in (0,1)),
  constraint ck_recip_filter_text_comp check ( text_comp in (0,1,2,3)),
  constraint ck_rcp_fltr_lst_sg_cmp check ( last_usage_comp in (0,1,2,3)),
  constraint uq_recip_filter_user_id unique (user_id),
  constraint pk_recip_filter primary key (id)
);
create sequence recip_filter_seq;

alter table recip_filter add constraint fk_recip_filter_user_id foreign key (user_id) references loginuser (id);


UPDATE applicationinfo SET prop_value='375' WHERE prop_name='db_layout';
