-- apply changes
create table user_effective_permission (
  id                            serial not null,
  bank_user_id                  integer not null,
  account_id                    integer not null,
  pmt_type                      integer not null,
  constraint ck_user_effective_permission_pmt_type check ( pmt_type in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49)),
  constraint pk_user_effective_permission primary key (id)
);

create index ix_user_effective_permission_bank_user_id on user_effective_permission (bank_user_id);
alter table user_effective_permission add constraint fk_user_effective_permission_bank_user_id foreign key (bank_user_id) references bankuser (id) on delete restrict on update restrict;

create index ix_user_effective_permission_account_id on user_effective_permission (account_id);
alter table user_effective_permission add constraint fk_user_effective_permission_account_id foreign key (account_id) references account (id) on delete restrict on update restrict;


UPDATE applicationinfo SET prop_value='364' WHERE prop_name='db_layout';
