-- apply changes

-- complicated way to delete all duplicated entries before creating the unique key
create table tmp_id (bank_id integer, min_id integer);
insert into tmp_id (bank_id, min_id) select bank_id, min(id) from nf_setting group by bank_id having count(*) > 1;
# it is more complicated on MySQL
#delete from nf_setting where id in (select nf_setting.id from nf_setting join tmp_id on nf_setting.bank_id=tmp_id.bank_id and nf_setting.id > tmp_id.min_id);
delete from nf_setting where id in (select A.id from (select * from nf_setting) as A join tmp_id on A.bank_id=tmp_id.bank_id and A.id > tmp_id.min_id);
delete from tmp_id;
insert into tmp_id (bank_id, min_id) select bank_id, min(id) from protocol_setting group by bank_id having count(*) > 1;
# it is more complicated on MySQL
#delete from protocol_setting where id in (select protocol_setting.id from protocol_setting join tmp_id on protocol_setting.bank_id=tmp_id.bank_id and protocol_setting.id > tmp_id.min_id);
delete from protocol_setting where id in (select A.id from (select * from protocol_setting) AS A join tmp_id on A.bank_id=tmp_id.bank_id and A.id > tmp_id.min_id);
drop table tmp_id;

-- now adding the new unique keys
alter table nf_setting add constraint uq_nf_setting_bank_id unique  (bank_id);
alter table protocol_setting add constraint uq_protocol_setting_bank_id unique  (bank_id);

UPDATE applicationinfo SET prop_value='359' WHERE prop_name='db_layout';
