-- apply changes
create table log (
  id                            integer auto_increment not null,
  log_time                      datetime,
  tenant_id                     integer,
  bank_id                       integer,
  message_id                    integer not null,
  parameter                     longblob,
  constraint pk_log primary key (id)
);

create index ix_log_tenant_id on log (tenant_id);
alter table log add constraint fk_log_tenant_id foreign key (tenant_id) references tenant (id) on delete restrict on update restrict;

create index ix_log_bank_id on log (bank_id);
alter table log add constraint fk_log_bank_id foreign key (bank_id) references bank (id) on delete restrict on update restrict;


UPDATE applicationinfo SET prop_value='350' WHERE prop_name='db_layout';
