-- apply changes
create table exportfile_filter (
  id                            number(10) not null,
  user_id                       number(10) not null,
  from_date                     date,
  to_date                       date,
  date_comp                     number(10),
  export_file_active            number(1) default 0 not null,
  automatic_export_id           number(10),
  file_name                     varchar2(255),
  file_name_comp                number(10) not null,
  constraint ck_exportfile_filter_date_comp check ( date_comp in (0,1,2,3)),
  constraint ck_exprtfl_fltr_fl_nm_cmp check ( file_name_comp in (0,1,2,3)),
  constraint pk_exportfile_filter primary key (id)
);
create sequence exportfile_filter_seq;

alter table pmt_filter drop constraint ck_pmt_filter_state;
alter table pmt_filter add constraint ck_pmt_filter_state check ( state in (0,1,2,3,4,5,6,7,8,9,10,11,12,13));
create index ix_exportfile_filter_user_id on exportfile_filter (user_id);
alter table exportfile_filter add constraint fk_exportfile_filter_user_id foreign key (user_id) references loginuser (id);


UPDATE applicationinfo SET prop_value='327' WHERE prop_name='db_layout';
