-- apply changes
create table exportfile_filter (
  id                            integer identity(1,1) not null,
  user_id                       integer not null,
  from_date                     date,
  to_date                       date,
  date_comp                     integer,
  export_file_active            bit default 0 not null,
  automatic_export_id           integer,
  file_name                     varchar(255),
  file_name_comp                integer not null,
  constraint ck_exportfile_filter_date_comp check ( date_comp in (0,1,2,3)),
  constraint ck_exportfile_filter_file_name_comp check ( file_name_comp in (0,1,2,3)),
  constraint pk_exportfile_filter primary key (id)
);

IF (OBJECT_ID('ck_pmt_filter_state', 'C') IS NOT NULL) alter table pmt_filter drop constraint ck_pmt_filter_state;
alter table pmt_filter add constraint ck_pmt_filter_state check ( state in (0,1,2,3,4,5,6,7,8,9,10,11,12,13));
create index ix_exportfile_filter_user_id on exportfile_filter (user_id);
alter table exportfile_filter add constraint fk_exportfile_filter_user_id foreign key (user_id) references loginuser (id);


UPDATE applicationinfo SET prop_value='327' WHERE prop_name='db_layout';
