-- apply changes
create table pdfstatements_filter (
  id                            number(10) not null,
  user_id                       number(10) not null,
  from_date                     date,
  to_date                       date,
  date_comp                     number(10),
  order_type                    varchar2(255),
  order_type_comp               number(10) not null,
  bank_id                       number(10),
  bank_comp                     number(10) not null,
  statement_active              number(1) default 0 not null,
  account_id                    number(10),
  constraint ck_pdfsttmnts_fltr_dt_cmp check ( date_comp in (0,1,2,3)),
  constraint ck_pdfsttmnts_fltr_rdr_typ_cmp check ( order_type_comp in (0,1,2,3)),
  constraint ck_pdfsttmnts_fltr_bnk_cmp check ( bank_comp in (0)),
  constraint pk_pdfstatements_filter primary key (id)
);
create sequence pdfstatements_filter_seq;

create index ix_pdfsttmnts_fltr_sr_d on pdfstatements_filter (user_id);
alter table pdfstatements_filter add constraint fk_pdfsttmnts_fltr_sr_d foreign key (user_id) references loginuser (id);

create index ix_pdfsttmnts_fltr_bnk_d on pdfstatements_filter (bank_id);
alter table pdfstatements_filter add constraint fk_pdfsttmnts_fltr_bnk_d foreign key (bank_id) references bank (id);


UPDATE applicationinfo SET prop_value='306' WHERE prop_name='db_layout';
