-- apply changes
create table pdfstatements_filter (
  id                            integer auto_increment not null,
  user_id                       integer not null,
  from_date                     date,
  to_date                       date,
  date_comp                     integer,
  order_type                    varchar(255),
  order_type_comp               integer not null,
  bank_id                       integer,
  bank_comp                     integer not null,
  statement_active              tinyint(1) default 0 not null,
  account_id                    integer,
  constraint pk_pdfstatements_filter primary key (id)
);

create index ix_pdfstatements_filter_user_id on pdfstatements_filter (user_id);
alter table pdfstatements_filter add constraint fk_pdfstatements_filter_user_id foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pdfstatements_filter_bank_id on pdfstatements_filter (bank_id);
alter table pdfstatements_filter add constraint fk_pdfstatements_filter_bank_id foreign key (bank_id) references bank (id) on delete restrict on update restrict;


UPDATE applicationinfo SET prop_value='306' WHERE prop_name='db_layout';
