-- apply changes
create table pdfstatements_filter (
  id                            integer not null,
  user_id                       integer not null,
  from_date                     date,
  to_date                       date,
  date_comp                     integer,
  order_type                    varchar(255),
  order_type_comp               integer not null,
  bank_id                       integer,
  bank_comp                     integer not null,
  statement_active              boolean default false not null,
  account_id                    integer,
  constraint ck_pdfstatements_filter_date_comp check ( date_comp in (0,1,2,3)),
  constraint ck_pdfstatements_filter_order_type_comp check ( order_type_comp in (0,1,2,3)),
  constraint ck_pdfstatements_filter_bank_comp check ( bank_comp in (0)),
  constraint pk_pdfstatements_filter primary key (id)
);
create sequence pdfstatements_filter_seq;

create index ix_pdfstatements_filter_user_id on pdfstatements_filter (user_id);
alter table pdfstatements_filter add constraint fk_pdfstatements_filter_user_id foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_pdfstatements_filter_bank_id on pdfstatements_filter (bank_id);
alter table pdfstatements_filter add constraint fk_pdfstatements_filter_bank_id foreign key (bank_id) references bank (id) on delete restrict on update restrict;


UPDATE applicationinfo SET prop_value='306' WHERE prop_name='db_layout';
