-- apply changes
create table cluster_node (
  id                            number(10) not null,
  base_url                      varchar2(255),
  secret                        varchar2(20),
  primary_node                  number(1) default 0 not null,
  constraint uq_cluster_node_base_url unique (base_url),
  constraint pk_cluster_node primary key (id)
);
create sequence cluster_node_seq;

create table workspace_file_cluster_node (
  workspace_file_id             number(10) not null,
  cluster_node_id               number(10) not null,
  constraint pk_workspace_file_cluster_node primary key (workspace_file_id,cluster_node_id)
);

create index ix_wrkspc_fl_clstr_nd_w_kntx6d on workspace_file_cluster_node (workspace_file_id);
alter table workspace_file_cluster_node add constraint fk_wrkspc_fl_clstr_nd_w_5pjp3z foreign key (workspace_file_id) references workspace_file (id);

create index ix_wrkspc_fl_clstr_nd_clstr_nd on workspace_file_cluster_node (cluster_node_id);
alter table workspace_file_cluster_node add constraint fk_wrkspc_fl_clstr_nd_clstr_nd foreign key (cluster_node_id) references cluster_node (id);


UPDATE applicationinfo SET prop_value='304' WHERE prop_name='db_layout';
