-- apply changes
create table cluster_node (
  id                            integer not null,
  base_url                      varchar(255),
  secret                        varchar(20),
  primary_node                  boolean default false not null,
  constraint uq_cluster_node_base_url unique (base_url),
  constraint pk_cluster_node primary key (id)
);
create sequence cluster_node_seq;

create table workspace_file_cluster_node (
  workspace_file_id             integer not null,
  cluster_node_id               integer not null,
  constraint pk_workspace_file_cluster_node primary key (workspace_file_id,cluster_node_id)
);

create index ix_workspace_file_cluster_node_workspace_file on workspace_file_cluster_node (workspace_file_id);
alter table workspace_file_cluster_node add constraint fk_workspace_file_cluster_node_workspace_file foreign key (workspace_file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_workspace_file_cluster_node_cluster_node on workspace_file_cluster_node (cluster_node_id);
alter table workspace_file_cluster_node add constraint fk_workspace_file_cluster_node_cluster_node foreign key (cluster_node_id) references cluster_node (id) on delete restrict on update restrict;


UPDATE applicationinfo SET prop_value='304' WHERE prop_name='db_layout';
