-- apply changes
create table workspace_file (
  id                            integer not null,
  prefix_id                     integer not null,
  action_mode                   integer not null,
  path                          varchar(256) not null,
  file_size                     bigint,
  md5hash                       varchar(32),
  sha256hash                    varchar(64),
  constraint ck_workspace_file_action_mode check ( action_mode in (0,1)),
  constraint pk_workspace_file primary key (id)
);
create sequence workspace_file_seq;

alter table cm_page add column file_id integer;

alter table cm_pdf_statement add column local_file_id integer;

alter table cm_statement add column file_id integer;

alter table ds_open_order add column order_data_id integer;

alter table ds_order_details add column data_file_id integer;

alter table fetch_item add column file_id integer;

alter table notification add column file_id integer;
alter table notification add column order_info varchar(255);

alter table send_item add column file_id integer;

create index ix_workspace_file_prefix_id_path on workspace_file (prefix_id,path);
create index ix_cm_page_file_id on cm_page (file_id);
alter table cm_page add constraint fk_cm_page_file_id foreign key (file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_cm_pdf_statement_local_file_id on cm_pdf_statement (local_file_id);
alter table cm_pdf_statement add constraint fk_cm_pdf_statement_local_file_id foreign key (local_file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_cm_statement_file_id on cm_statement (file_id);
alter table cm_statement add constraint fk_cm_statement_file_id foreign key (file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_ds_open_order_order_data_id on ds_open_order (order_data_id);
alter table ds_open_order add constraint fk_ds_open_order_order_data_id foreign key (order_data_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_ds_order_details_data_file_id on ds_order_details (data_file_id);
alter table ds_order_details add constraint fk_ds_order_details_data_file_id foreign key (data_file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_fetch_item_file_id on fetch_item (file_id);
alter table fetch_item add constraint fk_fetch_item_file_id foreign key (file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_notification_file_id on notification (file_id);
alter table notification add constraint fk_notification_file_id foreign key (file_id) references workspace_file (id) on delete restrict on update restrict;

create index ix_send_item_file_id on send_item (file_id);
alter table send_item add constraint fk_send_item_file_id foreign key (file_id) references workspace_file (id) on delete restrict on update restrict;

INSERT INTO workspace_file (id, prefix_id, action_mode, path, sha256hash) SELECT workspace_file_seq.nextval, 0,0,local_file,sha256hash from cm_pdf_statement where type=0 and local_file is not null;
INSERT INTO workspace_file (id, prefix_id, action_mode, path, sha256hash) SELECT workspace_file_seq.nextval, 1,0,local_file,sha256hash from cm_pdf_statement where type<>0 and local_file is not null;
INSERT INTO workspace_file (id, prefix_id, action_mode, path, md5hash,file_size) SELECT workspace_file_seq.nextval, 2,0,file_name,md5hash,file_size from cm_statement where file_name is not null and type in (0,1,3,4,6,29);
INSERT INTO workspace_file (id, prefix_id, action_mode, path, md5hash,file_size) SELECT workspace_file_seq.nextval, 2,0,file_name,md5hash,file_size from cm_page where file_name is not null;
INSERT INTO workspace_file (id, prefix_id, action_mode, path, md5hash,file_size) SELECT workspace_file_seq.nextval, 3,0,file_name,md5hash,file_size from cm_statement where file_name is not null and type not in (0,1,3,4,6,29);
INSERT INTO workspace_file (id, prefix_id, action_mode, path, file_size) SELECT workspace_file_seq.nextval, 4,0,file_name,file_size from fetch_item where file_name is not null;
INSERT INTO workspace_file (id, prefix_id, action_mode, path, md5hash,file_size) SELECT workspace_file_seq.nextval, 5,0,file_name,md5hash,file_size from send_item where file_name is not null;
INSERT INTO workspace_file (id, prefix_id, action_mode, path, file_size) SELECT workspace_file_seq.nextval, 6,0,data_file,datasize from ds_order_details where data_file is not null;
INSERT INTO workspace_file (id, prefix_id, action_mode, path, file_size) SELECT workspace_file_seq.nextval,6,0,order_data_file,datasize from ds_open_order where order_data_file is not null;
INSERT INTO workspace_file (id, prefix_id, action_mode, path, md5hash) SELECT workspace_file_seq.nextval, 7,0,file_name,md5hash from notification where file_name is not null and file_name not like 'SEND.%' and file_name not like 'PTK.%' and file_name not like 'HAC.%';

UPDATE cm_pdf_statement SET local_file_id = (SELECT id from workspace_file where workspace_file.path=cm_pdf_statement.local_file and workspace_file.prefix_id=0) where cm_pdf_statement.type=0 and cm_pdf_statement.local_file is not null;
UPDATE cm_pdf_statement SET local_file_id = (SELECT id from workspace_file where workspace_file.path=cm_pdf_statement.local_file and workspace_file.prefix_id=1) where cm_pdf_statement.type<>0 and cm_pdf_statement.local_file is not null;
UPDATE cm_statement SET file_id = (SELECT id from workspace_file where workspace_file.path=cm_statement.file_name and workspace_file.prefix_id=2) where cm_statement.file_name is not null and cm_statement.type in (0,1,3,4,6,29);
UPDATE cm_page SET file_id = (SELECT id from workspace_file where workspace_file.path=cm_page.file_name and workspace_file.prefix_id=2);
UPDATE cm_statement SET file_id = (SELECT id from workspace_file where workspace_file.path=cm_statement.file_name and workspace_file.prefix_id=3) where cm_statement.file_name is not null and cm_statement.type not in (0,1,3,4,6,29);
UPDATE fetch_item SET file_id = (SELECT id from workspace_file where workspace_file.path=fetch_item.file_name and workspace_file.prefix_id=4) where fetch_item.file_name is not null;
UPDATE send_item SET file_id = (SELECT id from workspace_file where workspace_file.path=send_item.file_name and workspace_file.prefix_id=5) where send_item.file_name is not null;
UPDATE ds_order_details SET data_file_id = (SELECT id from workspace_file where workspace_file.path=ds_order_details.data_file and workspace_file.prefix_id=6) where ds_order_details.data_file is not null;
UPDATE ds_open_order SET order_data_id = (SELECT id from workspace_file where workspace_file.path=ds_open_order.order_data_file and workspace_file.prefix_id=6) where ds_open_order.order_data_file is not null;
UPDATE notification SET file_id = (SELECT id from workspace_file where workspace_file.path=notification.file_name and workspace_file.prefix_id=7) where file_name is not null and file_name not like 'SEND.%' and file_name not like 'PTK.%' and file_name not like 'HAC.%';

UPDATE notification set order_info=file_name where file_name is not null and (file_name like 'SEND.%' or file_name like 'PTK.%' or file_name like 'HAC.%');
-- apply changes
alter table cm_page drop column file_name;

alter table cm_page drop column file_size;

alter table cm_page drop column md5hash;

alter table cm_pdf_statement drop column sha256hash;

alter table cm_pdf_statement drop column local_file;

alter table cm_statement drop column file_name;

alter table cm_statement drop column file_size;

alter table cm_statement drop column md5hash;

alter table ds_open_order drop column order_data_file;

alter table ds_order_details drop column data_file;

alter table fetch_item drop column file_name;

alter table fetch_item drop column file_size;

alter table notification drop column file_name;

alter table notification drop column md5hash;

alter table send_item drop column file_name;

alter table send_item drop column file_size;

alter table send_item drop column md5hash;


UPDATE applicationinfo SET prop_value='303' WHERE prop_name='db_layout';
