ALTER TABLE pmt_open ADD business_id integer;
ALTER TABLE pmt_open ADD created_user_id integer;
ALTER TABLE pmt_open ADD created datetime;
ALTER TABLE pmt_open ADD confirmed_user_id integer;
ALTER TABLE pmt_open ADD confirmed datetime;
ALTER TABLE pmt_open ADD version integer;
/* Note: Column "locking_user" already exists ! */
ALTER TABLE pmt_open ADD deleted tinyint(1) default 0;

UPDATE pmt_open SET business_id=id WHERE business_id is null;
UPDATE pmt_open SET version = 1 WHERE version is null;
UPDATE pmt_open SET created_user_id = (select min(user_id) FROM bankuser WHERE bankuser.bank_id=pmt_open.bank_id) WHERE created_user_id is null;
UPDATE pmt_open SET created = '1970-01-01 00:00:01.00' WHERE created is null;

DELETE FROM pmt_open WHERE created_user_id is null;

ALTER TABLE pmt_open MODIFY created_user_id integer not null;
ALTER TABLE pmt_open MODIFY created datetime not null;
ALTER TABLE pmt_open MODIFY version integer not null;

ALTER TABLE pmt_open ADD constraint fk_pmt_open_createdUser_1 foreign key (created_user_id) references loginuser (id) on delete restrict on update restrict;
create index ix_pmt_open_createdUser_1 on pmt_open (created_user_id);

ALTER TABLE pmt_open ADD constraint fk_pmt_open_confirmedUser_1 foreign key (confirmed_user_id) references loginuser (id) on delete restrict on update restrict;
create index ix_pmt_open_confirmedUser_1 on pmt_open (confirmed_user_id);

/* check constraints not supported by MySQL, nothing to do here */

ALTER TABLE pmt_periodic ADD business_id integer;
ALTER TABLE pmt_periodic ADD created_user_id integer;
ALTER TABLE pmt_periodic ADD created datetime;
ALTER TABLE pmt_periodic ADD confirmed_user_id integer;
ALTER TABLE pmt_periodic ADD confirmed datetime;
ALTER TABLE pmt_periodic ADD version integer;
ALTER TABLE pmt_periodic ADD locking_user_id integer;
ALTER TABLE pmt_periodic ADD deleted tinyint(1) default 0;

UPDATE pmt_periodic SET business_id=id WHERE business_id is null;
UPDATE pmt_periodic SET version = 1 WHERE version is null;
UPDATE pmt_periodic SET created_user_id = (select min(user_id) FROM bankuser WHERE bankuser.bank_id=pmt_periodic.bank_id) WHERE created_user_id is null;
UPDATE pmt_periodic SET created = '1970-01-01 00:00:01.00' WHERE created is null;

DELETE FROM pmt_periodic WHERE created_user_id is null;

ALTER TABLE pmt_periodic MODIFY created_user_id integer not null;
ALTER TABLE pmt_periodic MODIFY created datetime not null;
ALTER TABLE pmt_periodic MODIFY version integer not null;

ALTER TABLE pmt_periodic ADD constraint fk_pmt_periodic_createdUser_1 foreign key (created_user_id) references loginuser (id) on delete restrict on update restrict;
create index ix_pmt_periodic_createdUser_1 on pmt_periodic (created_user_id);

ALTER TABLE pmt_periodic ADD constraint fk_pmt_periodic_confirmedUser_1 foreign key (confirmed_user_id) references loginuser (id) on delete restrict on update restrict;
create index ix_pmt_periodic_confirmedUser_1 on pmt_periodic (confirmed_user_id);

ALTER TABLE pmt_periodic ADD constraint fk_pmt_periodic_lockingUser_1 foreign key (locking_user_id) references loginuser (id) on delete restrict on update restrict;
create index ix_pmt_periodic_lockingUser_1 on pmt_periodic (locking_user_id);

/* check constraints not supported by MySQL, nothing to do here */

UPDATE applicationinfo SET prop_value='244' WHERE prop_name='db_layout';
