ALTER TABLE pmt_open ADD business_id integer;
ALTER TABLE pmt_open ADD created_user_id integer;
ALTER TABLE pmt_open ADD created datetime;
ALTER TABLE pmt_open ADD confirmed_user_id integer;
ALTER TABLE pmt_open ADD confirmed datetime;
ALTER TABLE pmt_open ADD version integer;
/* Note: Column "locking_user" already exists ! */ 
ALTER TABLE pmt_open ADD deleted bit default 0;

update pmt_open set deleted=0;
UPDATE pmt_open SET business_id=id WHERE business_id is null;
UPDATE pmt_open SET version = 1 WHERE version is null;
UPDATE pmt_open SET created_user_id = (select min(user_id) FROM bankuser WHERE bankuser.bank_id=pmt_open.bank_id) WHERE created_user_id is null;
UPDATE pmt_open SET created = '1970-01-01 00:00:01.00' WHERE created is null;

DELETE FROM pmt_open WHERE created_user_id is null;

ALTER TABLE pmt_open ALTER COLUMN created_user_id integer not null;
ALTER TABLE pmt_open ALTER COLUMN created datetime not null;
ALTER TABLE pmt_open ALTER COLUMN version integer not null;

ALTER TABLE pmt_open ADD constraint fk_pmt_open_createdUser_1 foreign key (created_user_id) references loginuser (id);
create index ix_pmt_open_createdUser_1 on pmt_open (created_user_id);

ALTER TABLE pmt_open ADD constraint fk_pmt_open_confirmedUser_1 foreign key (confirmed_user_id) references loginuser (id);
create index ix_pmt_open_confirmedUser_1 on pmt_open (confirmed_user_id);

ALTER TABLE pmt_open ADD constraint ck_pmt_open_version check (version in (0,1,2));


ALTER TABLE pmt_periodic ADD business_id integer;
ALTER TABLE pmt_periodic ADD created_user_id integer;
ALTER TABLE pmt_periodic ADD created datetime;
ALTER TABLE pmt_periodic ADD confirmed_user_id integer;
ALTER TABLE pmt_periodic ADD confirmed datetime;
ALTER TABLE pmt_periodic ADD version integer;
ALTER TABLE pmt_periodic ADD locking_user_id integer;
ALTER TABLE pmt_periodic ADD deleted bit default 0;

update pmt_periodic set deleted=0;
UPDATE pmt_periodic SET business_id=id WHERE business_id is null;
UPDATE pmt_periodic SET version = 1 WHERE version is null;
UPDATE pmt_periodic SET created_user_id = (select min(user_id) FROM bankuser WHERE bankuser.bank_id=pmt_periodic.bank_id) WHERE created_user_id is null;
UPDATE pmt_periodic SET created = '1970-01-01 00:00:01.00' WHERE created is null;

DELETE FROM pmt_periodic WHERE created_user_id is null;

ALTER TABLE pmt_periodic ALTER COLUMN created_user_id integer not null;
ALTER TABLE pmt_periodic ALTER COLUMN created datetime not null;
ALTER TABLE pmt_periodic ALTER COLUMN version integer not null;

ALTER TABLE pmt_periodic ADD constraint fk_pmt_periodic_createdUser_1 foreign key (created_user_id) references loginuser (id);
create index ix_pmt_periodic_createdUser_1 on pmt_periodic (created_user_id);

ALTER TABLE pmt_periodic ADD constraint fk_pmt_periodic_confirmedUser_1 foreign key (confirmed_user_id) references loginuser (id);
create index ix_pmt_periodic_confirmedUser_1 on pmt_periodic (confirmed_user_id);

ALTER TABLE pmt_periodic ADD constraint fk_pmt_periodic_lockingUser_1 foreign key (locking_user_id) references loginuser (id);
create index ix_pmt_periodic_lockingUser_1 on pmt_periodic (locking_user_id);

ALTER TABLE pmt_periodic ADD constraint ck_pmt_periodic_version check (version in (0,1,2));


UPDATE applicationinfo SET prop_value='244' WHERE prop_name='db_layout';
