create table ptk_filter (
  id                        integer auto_increment not null,
  user_id                   integer not null,
  from_date                 date,
  to_date                   date,
  date_comp                 integer,
  order_type                varchar(255),
  order_type_comp           integer not null,
  order_nr                  varchar(255),
  order_nr_comp             integer not null,
  axn                       integer,
  result                    integer,
  constraint ck_ptk_filter_date_comp check (date_comp in (0,1,2,3)),
  constraint ck_ptk_filter_order_type_comp check (order_type_comp in (0,1)),
  constraint ck_ptk_filter_order_nr_comp check (order_nr_comp in (0,1)),
  constraint pk_ptk_filter primary key (id))
;

alter table ptk_filter add constraint fk_ptk_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_ptk_filter_user_1 on ptk_filter (user_id);

UPDATE applicationinfo SET prop_value='222' WHERE prop_name='db_layout';
