ALTER session SET nls_length_semantics=CHAR;

create table hac_filter (
  id                        number(10) not null,
  user_id                   number(10) not null,
  from_date                 date,
  to_date                   date,
  date_comp                 number(10),
  order_type                varchar2(255),
  order_type_comp           number(10) not null,
  order_nr                  varchar2(255),
  order_nr_comp             number(10) not null,
  axn                       number(10),
  customer_id               varchar2(35),
  bank_user_id              varchar2(35),
  reason                    varchar2(4),
  constraint ck_hac_filter_date_comp check (date_comp in (0,1,2,3)),
  constraint ck_hac_filter_order_type_comp check (order_type_comp in (0,1)),
  constraint ck_hac_filter_order_nr_comp check (order_nr_comp in (0,1)),
  constraint pk_hac_filter primary key (id))
;

create sequence hac_filter_seq;

alter table hac_filter add constraint fk_hac_filter_user_1 foreign key (user_id) references loginuser (id);

create index ix_hac_filter_user_1 on hac_filter (user_id);

UPDATE applicationinfo SET prop_value='221' WHERE prop_name='db_layout';
