create table hac_filter (
  id                        integer not null,
  user_id                   integer not null,
  from_date                 date,
  to_date                   date,
  date_comp                 integer,
  order_type                varchar(255),
  order_type_comp           integer not null,
  order_nr                  varchar(255),
  order_nr_comp             integer not null,
  axn                       integer,
  customer_id               varchar(35),
  bank_user_id              varchar(35),
  reason                    varchar(4),
  constraint ck_hac_filter_date_comp check (date_comp in (0,1,2,3)),
  constraint ck_hac_filter_order_type_comp check (order_type_comp in (0,1)),
  constraint ck_hac_filter_order_nr_comp check (order_nr_comp in (0,1)),
  constraint pk_hac_filter primary key (id))
;

create sequence hac_filter_seq;

alter table hac_filter add constraint fk_hac_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;

create index ix_hac_filter_user_1 on hac_filter (user_id);

UPDATE applicationinfo SET prop_value='221' WHERE prop_name='db_layout';
