create table fe_filter (
  id                        integer identity(1,1) not null,
  user_id                   integer not null,
  bank_id                   integer,
  bank_comp                 integer not null,
  order_type                varchar(255),
  order_type_comp           integer not null,
  from_date                 datetime,
  to_date                   datetime,
  date_comp                 integer,
  constraint ck_fe_filter_bank_comp check (bank_comp in (0)),
  constraint ck_fe_filter_order_type_comp check (order_type_comp in (0,1)),
  constraint ck_fe_filter_date_comp check (date_comp in (0,1,2,3)),
  constraint pk_fe_filter primary key (id))
;

alter table fe_filter add constraint fk_fe_filter_user_1 foreign key (user_id) references loginuser (id);
create index ix_fe_filter_user_1 on fe_filter (user_id);
alter table fe_filter add constraint fk_fe_filter_bank_1 foreign key (bank_id) references bank (id);
create index ix_fe_filter_bank_1 on fe_filter (bank_id);

create table nf_filter (
  id                        integer identity(1,1) not null,
  user_id                   integer not null,
  bank_id                   integer,
  bank_comp                 integer not null,
  order_type                varchar(255),
  order_type_comp           integer not null,
  from_date                 datetime,
  to_date                   datetime,
  date_comp                 integer,
  constraint ck_nf_filter_bank_comp check (bank_comp in (0)),
  constraint ck_nf_filter_order_type_comp check (order_type_comp in (0,1)),
  constraint ck_nf_filter_date_comp check (date_comp in (0,1,2,3)),
  constraint pk_nf_filter primary key (id))
;

alter table nf_filter add constraint fk_nf_filter_user_1 foreign key (user_id) references loginuser (id);
create index ix_nf_filter_user_1 on nf_filter (user_id);
alter table nf_filter add constraint fk_nf_filter_bank_1 foreign key (bank_id) references bank (id);
create index ix_nf_filter_bank_1 on nf_filter (bank_id);

UPDATE applicationinfo SET prop_value='208' WHERE prop_name='db_layout';
