create table nf_setting (
  id                        integer not null,
  bank_id                   integer,
  active                    boolean,
  credit_notifications      boolean,
  debit_notifications       boolean,
  instant_notifications     boolean,
  fetch_mode                integer,
  last_fetch                date,
  constraint ck_nf_setting_fetch_mode check (fetch_mode in (0,1)),
  constraint pk_nf_setting primary key (id))
;

create sequence nf_setting_seq;

alter table nf_setting add constraint fk_nf_setting_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;
create index ix_nf_setting_bank_1 on nf_setting (bank_id);

UPDATE applicationinfo SET prop_value='204' WHERE prop_name='db_layout';
