ALTER session SET nls_length_semantics=CHAR;
create table tenant (
  id                        number(10) not null,
  name                      varchar2(256) not null,
  constraint uq_tenant_name unique (name),
  constraint pk_tenant primary key (id))
;
create sequence tenant_seq increment by 1;

insert into tenant (id, name)
	values (tenant_seq.nextval, 'DEFAULT');

create table loginuser_tenant (
  loginuser_id                   number(10) not null,
  tenant_id                      number(10) not null,
  constraint pk_loginuser_tenant primary key (loginuser_id, tenant_id))
;
alter table loginuser_tenant add constraint fk_loginuser_tenant_loginus_01 foreign key (loginuser_id) references loginuser (id);
alter table loginuser_tenant add constraint fk_loginuser_tenant_tenant_02 foreign key (tenant_id) references tenant (id);

insert into loginuser_tenant (loginuser_id, tenant_id) 
	select id, 1 
	from loginuser;

alter table automatic_export add tenant_id number(10);
update automatic_export set tenant_id = 1;
alter table automatic_export modify tenant_id not null;
alter table automatic_export add constraint fk_automatic_export_tenant_1 foreign key (tenant_id) references tenant (id);
create index ix_automatic_export_tenant_1 on automatic_export (tenant_id);

alter table awv_entry add tenant_id number(10);
update awv_entry set tenant_id = 1;
alter table awv_entry modify tenant_id not null;
alter table awv_entry add constraint fk_awv_entry_tenant_1 foreign key (tenant_id) references tenant (id);
create index ix_awv_entry_tenant_1 on awv_entry (tenant_id);

alter table awv_export add tenant_id number(10);
update awv_export set tenant_id = 1;
alter table awv_export modify tenant_id not null;
alter table awv_export add constraint fk_awv_export_tenant_1 foreign key (tenant_id) references tenant (id);
create index ix_awv_export_tenant_1 on awv_export (tenant_id);

alter table awv_company add tenant_id number(10);
update awv_company set tenant_id = 1;
alter table awv_company modify tenant_id not null;
alter table awv_company add constraint fk_awv_company_tenant_1 foreign key (tenant_id) references tenant (id);
create index ix_awv_company_tenant_1 on awv_company (tenant_id);

alter table bank add tenant_id number(10);
update bank set tenant_id = 1;
alter table bank modify tenant_id not null;
alter table bank add constraint fk_bank_tenant_1 foreign key (tenant_id) references tenant (id);
create index ix_bank_tenant_1 on bank (tenant_id);

alter table cm_folder add tenant_id number(10);
update cm_folder set tenant_id = 1;
alter table cm_folder modify tenant_id not null;
alter table cm_folder add constraint fk_cm_folder_tenant_1 foreign key (tenant_id) references tenant (id);
create index ix_cm_folder_tenant_1 on cm_folder (tenant_id);

alter table cm_value_group add tenant_id number(10);
update cm_value_group set tenant_id = 1;
alter table cm_value_group modify tenant_id not null;
alter table cm_value_group add constraint fk_cm_value_group_tenant_1 foreign key (tenant_id) references tenant (id);
create index ix_cm_value_group_tenant_1 on cm_value_group (tenant_id);

alter table conversion add tenant_id number(10);
update conversion set tenant_id = 1;
alter table conversion modify tenant_id not null;
alter table conversion add constraint fk_conversion_tenant_1 foreign key (tenant_id) references tenant (id);
create index ix_conversion_tenant_1 on conversion (tenant_id);

alter table sepa_converter_format add tenant_id number(10);
update sepa_converter_format set tenant_id = 1;
alter table sepa_converter_format modify tenant_id not null;
alter table sepa_converter_format add constraint fk_sepa_converter_format_ten_1 foreign key (tenant_id) references tenant (id);
create index ix_sepa_converter_format_ten_1 on sepa_converter_format (tenant_id);

alter table pmt_folder add tenant_id number(10);
update pmt_folder set tenant_id = 1;
alter table pmt_folder modify tenant_id not null;
alter table pmt_folder add constraint fk_pmt_folder_tenant_1 foreign key (tenant_id) references tenant (id);
create index ix_pmt_folder_tenant_1 on pmt_folder (tenant_id);

alter table pmt_originator add tenant_id number(10);
update pmt_originator set tenant_id = 1;
alter table pmt_originator modify tenant_id not null;
alter table pmt_originator add constraint fk_pmt_originator_tenant_1 foreign key (tenant_id) references tenant (id);
create index ix_pmt_originator_tenant_1 on pmt_originator (tenant_id);

alter table pmt_recipient add tenant_id number(10);
update pmt_recipient set tenant_id = 1;
alter table pmt_recipient modify tenant_id not null;
alter table pmt_recipient add constraint fk_pmt_recipient_tenant_1 foreign key (tenant_id) references tenant (id);
create index ix_pmt_recipient_tenant_1 on pmt_recipient (tenant_id);

alter table preference add tenant_id number(10);
alter table preference add constraint fk_preference_tenant_1 foreign key (tenant_id) references tenant (id);
create index ix_preference_tenant_1 on preference (tenant_id);

UPDATE applicationinfo SET prop_value='201' WHERE prop_name='db_layout';
