alter table notification add send_id integer;
alter table notification add orgnl_msg_id varchar(35);
alter table notification add orgnl_msg_nm_id varchar(255);
alter table notification add orgnl_nb_of_txs integer;
alter table notification add orgnl_ctrl_sum decimal(38,3);
alter table notification add grp_sts varchar(4);

create table notification_pmt_inf (
  id                        serial not null,
  notification_id           integer,
  orgnl_pmt_inf_id          varchar(35),
  orgnl_nb_of_txs           integer,
  orgnl_ctrl_sum            decimal(38),
  pmt_inf_sts               varchar(4),
  constraint pk_notification_pmt_inf primary key (id))
;

create table notification_trx (
  id                        serial not null,
  notification_id           integer,
  pmt_inf_id                integer,
  orgnl_instr_id            varchar(255),
  orgnl_end_to_end_id       varchar(255),
  tx_sts                    varchar(4),
  constraint pk_notification_trx primary key (id))
;

alter table notification add constraint fk_notification_send_1 foreign key (send_id) references send_item (id);
create index ix_notification_send_1 on notification (send_id);
alter table notification_pmt_inf add constraint fk_notification_pmt_inf_notifi_1 foreign key (notification_id) references notification (id);
create index ix_notification_pmt_inf_notifi_1 on notification_pmt_inf (notification_id);
alter table notification_trx add constraint fk_notification_trx_notificati_1 foreign key (notification_id) references notification (id);
create index ix_notification_trx_notificati_1 on notification_trx (notification_id);
alter table notification_trx add constraint fk_notification_trx_pmtInf_1 foreign key (pmt_inf_id) references notification_pmt_inf (id);
create index ix_notification_trx_pmtInf_1 on notification_trx (pmt_inf_id);

UPDATE applicationinfo SET prop_value='190' WHERE prop_name='db_layout';
