ALTER TABLE pmt_recipient ADD business_id integer;
ALTER TABLE pmt_recipient ADD created_user_id integer;
ALTER TABLE pmt_recipient ADD created timestamp;
ALTER TABLE pmt_recipient ADD confirmed_user_id integer;
ALTER TABLE pmt_recipient ADD confirmed timestamp;
ALTER TABLE pmt_recipient ADD version integer;

UPDATE pmt_recipient SET business_id=id WHERE business_id is null;
UPDATE pmt_recipient SET version = 1 WHERE version is null;
UPDATE pmt_recipient SET created_user_id = (select min(id) from loginuser) WHERE created_user_id is null;
UPDATE pmt_recipient SET created = CURRENT_TIMESTAMP WHERE created is null;

ALTER TABLE pmt_recipient ALTER COLUMN created_user_id set not null;
ALTER TABLE pmt_recipient ALTER COLUMN created set not null;
ALTER TABLE pmt_recipient ALTER COLUMN version set not null;

ALTER TABLE pmt_recipient ADD constraint ck_pmt_recipient_version check (version in (0,1,2));
alter table pmt_recipient add constraint fk_pmt_recipient_createdUser_1 foreign key (created_user_id) references loginuser (id);
create index ix_pmt_recipient_createdUser_1 on pmt_recipient (created_user_id);
alter table pmt_recipient add constraint fk_pmt_recipient_confirmedUser_1 foreign key (confirmed_user_id) references loginuser (id);
create index ix_pmt_recipient_confirmedUser_1 on pmt_recipient (confirmed_user_id);

# finally migrate the preference we use for this
UPDATE preference SET pref_value='ALLOWED' where application_id=4 and pref_key='allowRecipientRecording' and pref_value='true';
UPDATE preference SET pref_value='DENIED' where application_id=4 and pref_key='allowRecipientRecording' and pref_value='false';

UPDATE applicationinfo SET prop_value='173' WHERE prop_name='db_layout';
