ALTER TABLE pmt_filter DROP COLUMN filter_active;
ALTER TABLE pmt_filter ADD  pmt_open_active number(1);
ALTER TABLE pmt_filter ADD  pmt_signed_active number(1);

create table send_filter (
  id                        number(10) not null,
  user_id                   number(10) not null,
  send_active               number(1),
  ds_signed_active          number(1),
  ds_cncl_active            number(1),
  bank_comp                 number(10) not null,
  order_type                varchar2(255),
  order_type_comp           number(10) not null,
  order_nr                  varchar2(255),
  order_nr_comp             number(10) not null,
  send_state                number(10),
  ds_state                  number(10),
  state_comp                number(10) not null,
  from_date                 date,
  to_date                   date,
  date_comp                 number(10),
  from_amount               number(38,3),
  to_amount                 number(38,3),
  amount_comp               number(10),
  constraint ck_send_filter_bank_comp check (bank_comp in (0)),
  constraint ck_send_filter_order_type_comp check (order_type_comp in (0)),
  constraint ck_send_filter_order_nr_comp check (order_nr_comp in (0)),
  constraint ck_send_filter_send_state check (send_state in (0,1,2,3,4,5,6,7)),
  constraint ck_send_filter_ds_state check (ds_state in (0,1,2,3,4,5)),
  constraint ck_send_filter_state_comp check (state_comp in (0)),
  constraint ck_send_filter_date_comp check (date_comp in (0,1,2,3)),
  constraint ck_send_filter_amount_comp check (amount_comp in (0,1,2,3)),
  constraint pk_send_filter primary key (id))
;

ALTER TABLE sorting DROP constraint ck_sorting_table_name;
ALTER TABLE sorting ADD constraint ck_sorting_table_name check (table_name in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31));

create sequence send_filter_seq increment by 1;

alter table send_filter add constraint fk_send_filter_user_1 foreign key (user_id) references loginuser (id);
create index ix_send_filter_user_1 on send_filter (user_id);

UPDATE applicationinfo SET prop_value='157' WHERE prop_name='db_layout';
