ALTER TABLE pmt_filter DROP COLUMN filter_active;
ALTER TABLE pmt_filter ADD pmt_open_active tinyint(1) default 0;
ALTER TABLE pmt_filter ADD pmt_signed_active tinyint(1) default 0;

create table send_filter (
  id                        integer auto_increment not null,
  user_id                   integer not null,
  send_active               tinyint(1) default 0,
  ds_signed_active          tinyint(1) default 0,
  ds_cncl_active            tinyint(1) default 0,
  bank_comp                 integer not null,
  order_type                varchar(255),
  order_type_comp           integer not null,
  order_nr                  varchar(255),
  order_nr_comp             integer not null,
  send_state                integer,
  ds_state                  integer,
  state_comp                integer not null,
  from_date                 date,
  to_date                   date,
  date_comp                 integer,
  from_amount               decimal(38,3),
  to_amount                 decimal(38,3),
  amount_comp               integer,
  constraint pk_send_filter primary key (id))
;

# mysql does not support any check-constraint

alter table send_filter add constraint fk_send_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;
create index ix_send_filter_user_1 on send_filter (user_id);

UPDATE applicationinfo SET prop_value='157' WHERE prop_name='db_layout';
