ALTER TABLE pmt_filter DROP COLUMN filter_active;
ALTER TABLE pmt_filter ADD pmt_open_active boolean;
ALTER TABLE pmt_filter ADD pmt_signed_active boolean;

create table send_filter (
  id                        integer not null,
  user_id                   integer not null,
  send_active               boolean,
  ds_signed_active          boolean,
  ds_cncl_active            boolean,
  bank_comp                 integer not null,
  order_type                varchar(255),
  order_type_comp           integer not null,
  order_nr                  varchar(255),
  order_nr_comp             integer not null,
  send_state                integer,
  ds_state                  integer,
  state_comp                integer not null,
  from_date                 date,
  to_date                   date,
  date_comp                 integer,
  from_amount               decimal(38,3),
  to_amount                 decimal(38,3),
  amount_comp               integer,
  constraint ck_send_filter_bank_comp check (bank_comp in (0)),
  constraint ck_send_filter_order_type_comp check (order_type_comp in (0)),
  constraint ck_send_filter_order_nr_comp check (order_nr_comp in (0)),
  constraint ck_send_filter_send_state check (send_state in (0,1,2,3,4,5,6,7)),
  constraint ck_send_filter_ds_state check (ds_state in (0,1,2,3,4,5)),
  constraint ck_send_filter_state_comp check (state_comp in (0)),
  constraint ck_send_filter_date_comp check (date_comp in (0,1,2,3)),
  constraint ck_send_filter_amount_comp check (amount_comp in (0,1,2,3)),
  constraint pk_send_filter primary key (id))
;

ALTER TABLE sorting DROP CONSTRAINT IF EXISTS ck_sorting_table_name;
ALTER TABLE sorting ADD CONSTRAINT ck_sorting_table_name check (table_name in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32));

create sequence send_filter_seq;

alter table send_filter add constraint fk_send_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;
create index ix_send_filter_user_1 on send_filter (user_id);

UPDATE applicationinfo SET prop_value='157' WHERE prop_name='db_layout';
