ALTER session SET nls_length_semantics=CHAR;
ALTER TABLE bankuser MODIFY order_number varchar2(4) NULL;

create table cm_pdf_statement (
  id                        number(10) not null,
  bank_id                   number(10),
  account_id                number(10),
  statement_date            date,
  sha256hash                varchar2(64),
  zip_file_name             varchar2(255),
  local_file                varchar2(255),
  constraint pk_cm_pdf_statement primary key (id))
;

create table directory_scanner (
  id                        number(10) not null,
  directory                 varchar2(255) not null,
  reg_ex                    varchar2(255),
  archive_directory         varchar2(255),
  constraint pk_directory_scanner primary key (id))
;

create table scheduler (
  id                        number(10) not null,
  bank_user_id              number(10),
  order_or_file_type        varchar2(255),
  days                      varchar2(255),
  month                     varchar2(255),
  hour                      varchar2(255),
  minute                    varchar2(255),
  year                      varchar2(255),
  constraint pk_scheduler primary key (id))
;

create sequence cm_pdf_statement_seq;

create sequence directory_scanner_seq;

create sequence scheduler_seq;

alter table cm_pdf_statement add constraint fk_cm_pdf_statement_bank_1 foreign key (bank_id) references bank (id);
create index ix_cm_pdf_statement_bank_1 on cm_pdf_statement (bank_id);
alter table cm_pdf_statement add constraint fk_cm_pdf_statement_account_1 foreign key (account_id) references account (id);
create index ix_cm_pdf_statement_account_1 on cm_pdf_statement (account_id);

alter table scheduler add constraint fk_scheduler_bankUser_1 foreign key (bank_user_id) references bankuser (id);
create index ix_scheduler_bankUser_1 on scheduler (bank_user_id);

UPDATE applicationinfo SET prop_value='135' WHERE prop_name='db_layout';
