ALTER TABLE bankuser ALTER COLUMN order_number varchar(4) NULL;

create table cm_pdf_statement (
  id                        integer identity(1,1) not null,
  bank_id                   integer,
  account_id                integer,
  statement_date            datetime,
  sha256hash                varchar(64),
  zip_file_name             varchar(255),
  local_file                varchar(255),
  constraint pk_cm_pdf_statement primary key (id))
;

create table directory_scanner (
  id                        integer identity(1,1) not null,
  directory                 varchar(255) not null,
  reg_ex                    varchar(255),
  archive_directory         varchar(255),
  constraint pk_directory_scanner primary key (id))
;

create table scheduler (
  id                        integer identity(1,1) not null,
  bank_user_id              integer,
  order_or_file_type        varchar(255),
  days                      varchar(255),
  month                     varchar(255),
  hour                      varchar(255),
  minute                    varchar(255),
  year                      varchar(255),
  constraint pk_scheduler primary key (id))
;

alter table cm_pdf_statement add constraint fk_cm_pdf_statement_bank_1 foreign key (bank_id) references bank (id);
create index ix_cm_pdf_statement_bank_1 on cm_pdf_statement (bank_id);
alter table cm_pdf_statement add constraint fk_cm_pdf_statement_account_1 foreign key (account_id) references account (id);
create index ix_cm_pdf_statement_account_1 on cm_pdf_statement (account_id);

alter table scheduler add constraint fk_scheduler_bankUser_1 foreign key (bank_user_id) references bankuser (id);
create index ix_scheduler_bankUser_1 on scheduler (bank_user_id);

UPDATE applicationinfo SET prop_value='135' WHERE prop_name='db_layout';
