  ALTER TABLE bankuser ALTER COLUMN order_number varchar(4) NULL;

  create table cm_pdf_statement (
  id                        integer not null,
  bank_id                   integer,
  account_id                integer,
  statement_date            date,
  sha256hash                varchar(64),
  zip_file_name             varchar(255),
  local_file                varchar(255),
  constraint pk_cm_pdf_statement primary key (id))
;

create table directory_scanner (
  id                        integer not null,
  directory                 varchar(255) not null,
  reg_ex                    varchar(255),
  archive_directory         varchar(255),
  constraint pk_directory_scanner primary key (id))
;

create table scheduler (
  id                        integer not null,
  bank_user_id              integer,
  order_or_file_type        varchar(255),
  days                      varchar(255),
  month                     varchar(255),
  hour                      varchar(255),
  minute                    varchar(255),
  year                      varchar(255),
  constraint pk_scheduler primary key (id))
;

create sequence cm_pdf_statement_seq;

create sequence directory_scanner_seq;

create sequence scheduler_seq;

alter table cm_pdf_statement add constraint fk_cm_pdf_statement_bank_1 foreign key (bank_id) references bank (id) on delete restrict on update restrict;
create index ix_cm_pdf_statement_bank_1 on cm_pdf_statement (bank_id);
alter table cm_pdf_statement add constraint fk_cm_pdf_statement_account_1 foreign key (account_id) references account (id) on delete restrict on update restrict;
create index ix_cm_pdf_statement_account_1 on cm_pdf_statement (account_id);

alter table scheduler add constraint fk_scheduler_bankUser_1 foreign key (bank_user_id) references bankuser (id) on delete restrict on update restrict;
create index ix_scheduler_bankUser_1 on scheduler (bank_user_id);

UPDATE applicationinfo SET prop_value='135' WHERE prop_name='db_layout';
