ALTER session SET nls_length_semantics=CHAR;

create table cm_b_filter (
  id                        number(10) not null,
  user_id                   number(10) not null,
  booking_date_from         date,
  booking_date_to           date,
  bd_comp                   number(10),
  value_date_from           date,
  value_date_to             date,
  vd_comp                   number(10),
  text                      varchar2(255),
  text_comp                 number(10),
  amount_from               number(38),
  amount_to                 number(38),
  amount_comp               number(10),
  constraint ck_cm_b_filter_bd_comp check (bd_comp in (0,1,2,3)),
  constraint ck_cm_b_filter_vd_comp check (vd_comp in (0,1,2,3)),
  constraint ck_cm_b_filter_text_comp check (text_comp in (0)),
  constraint ck_cm_b_filter_amount_comp check (amount_comp in (0,1,2,3)),
  constraint uq_cm_b_filter_user_id unique (user_id),
  constraint pk_cm_b_filter primary key (id))
;

create sequence cm_b_filter_seq increment by 1;

alter table cm_b_filter add constraint fk_cm_b_filter_user_1 foreign key (user_id) references loginuser (id);

UPDATE applicationinfo SET prop_value='129' WHERE prop_name='db_layout';
