create table cm_b_filter (
  id                        integer identity(1,1) not null,
  user_id                   integer not null,
  booking_date_from         datetime,
  booking_date_to           datetime,
  bd_comp                   integer,
  value_date_from           datetime,
  value_date_to             datetime,
  vd_comp                   integer,
  text                      varchar(255),
  text_comp                 integer,
  amount_from               numeric(28),
  amount_to                 numeric(28),
  amount_comp               integer,
  constraint ck_cm_b_filter_bd_comp check (bd_comp in (0,1,2,3)),
  constraint ck_cm_b_filter_vd_comp check (vd_comp in (0,1,2,3)),
  constraint ck_cm_b_filter_text_comp check (text_comp in (0)),
  constraint ck_cm_b_filter_amount_comp check (amount_comp in (0,1,2,3)),
  constraint uq_cm_b_filter_user_id unique (user_id),
  constraint pk_cm_b_filter primary key (id))
;

alter table cm_b_filter add constraint fk_cm_b_filter_user_1 foreign key (user_id) references loginuser (id);
create index ix_cm_b_filter_user_1 on cm_b_filter (user_id);

UPDATE applicationinfo SET prop_value='129' WHERE prop_name='db_layout';
