create table cm_b_filter (
  id                        integer not null,
  user_id                   integer not null,
  booking_date_from         date,
  booking_date_to           date,
  bd_comp                   integer,
  value_date_from           date,
  value_date_to             date,
  vd_comp                   integer,
  text                      varchar(255),
  text_comp                 integer,
  amount_from               decimal(38),
  amount_to                 decimal(38),
  amount_comp               integer,
  constraint ck_cm_b_filter_bd_comp check (bd_comp in (0,1,2,3)),
  constraint ck_cm_b_filter_vd_comp check (vd_comp in (0,1,2,3)),
  constraint ck_cm_b_filter_text_comp check (text_comp in (0)),
  constraint ck_cm_b_filter_amount_comp check (amount_comp in (0,1,2,3)),
  constraint uq_cm_b_filter_user_id unique (user_id),
  constraint pk_cm_b_filter primary key (id))
;

create sequence cm_b_filter_seq;

alter table cm_b_filter add constraint fk_cm_b_filter_user_1 foreign key (user_id) references loginuser (id) on delete restrict on update restrict;
create index ix_cm_b_filter_user_1 on cm_b_filter (user_id);

UPDATE applicationinfo SET prop_value='129' WHERE prop_name='db_layout';
