create table ds_open_order (
  id                        number(10) not null,
  bank_user_id              number(10),
  file_type                 varchar2(50) not null,
  order_id                  varchar2(4) not null,
  submission_date           timestamp not null,
  customer_id               varchar2(35) not null,
  user_id                   varchar2(35),
  user_name                 varchar2(40),
  amount                    number(38,3),
  amount_currency           varchar2(3),
  datasize                  number(19),
  originator                varchar2(80),
  digest_hex                varchar2(80),
  is_signable               number(1),
  is_order_data_available   number(1),
  is_payment_data_available number(1),
  ticket                    blob,
  constraint pk_ds_open_order primary key (id))
;

create table ds_open_order_signer (
  id                        number(10) not null,
  ds_open_order_id          number(10),
  sign_date                 timestamp not null,
  customer_id               varchar2(35) not null,
  user_id                   varchar2(35),
  user_name                 varchar2(40),
  permission                varchar2(1) not null,
  constraint pk_ds_open_order_signer primary key (id))
;

create sequence ds_open_order_seq increment by 1;

create sequence ds_open_order_signer_seq increment by 1;

alter table ds_open_order add constraint fk_ds_open_order_bankUser_1 foreign key (bank_user_id) references bankuser (id);
create index ix_ds_open_order_bankUser_1 on ds_open_order (bank_user_id);
alter table ds_open_order_signer add constraint fk_ds_open_order_signer_dsOp_1 foreign key (ds_open_order_id) references ds_open_order (id);
create index ix_ds_open_order_signer_dsOp_1 on ds_open_order_signer (ds_open_order_id);

UPDATE applicationinfo SET prop_value='128' WHERE prop_name='db_layout';
