create table ds_open_order (
  id                        integer not null,
  bank_user_id              integer,
  file_type                 varchar(50) not null,
  order_id                  varchar(4) not null,
  submission_date           timestamp not null,
  customer_id               varchar(35) not null,
  user_id                   varchar(35),
  user_name                 varchar(40),
  amount                    decimal(38,3),
  amount_currency           varchar(3),
  datasize                  bigint,
  originator                varchar(80),
  digest_hex                varchar(80),
  is_signable               boolean,
  is_order_data_available   boolean,
  is_payment_data_available boolean,
  ticket                    blob,
  constraint pk_ds_open_order primary key (id))
;

create table ds_open_order_signer (
  id                        integer not null,
  ds_open_order_id          integer,
  sign_date                 timestamp not null,
  customer_id               varchar(35) not null,
  user_id                   varchar(35),
  user_name                 varchar(40),
  permission                varchar(1) not null,
  constraint pk_ds_open_order_signer primary key (id))
;

create sequence ds_open_order_seq;

create sequence ds_open_order_signer_seq;

alter table ds_open_order add constraint fk_ds_open_order_bankUser_1 foreign key (bank_user_id) references bankuser (id) on delete restrict on update restrict;
create index ix_ds_open_order_bankUser_1 on ds_open_order (bank_user_id);
alter table ds_open_order_signer add constraint fk_ds_open_order_signer_dsOpen_1 foreign key (ds_open_order_id) references ds_open_order (id) on delete restrict on update restrict;
create index ix_ds_open_order_signer_dsOpen_1 on ds_open_order_signer (ds_open_order_id);

UPDATE applicationinfo SET prop_value='128' WHERE prop_name='db_layout';
